/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.sound;

import com.google.common.base.Preconditions;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Location;
import org.bukkit.SoundCategory;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class AudioExperience {
    @NotNull
    private final String sound;
    @NotNull
    private final SoundCategory category;
    @NotNull
    private final Location location;
    private final float volume;
    private final float pitch;

    @ApiStatus.Internal
    public AudioExperience(@NotNull String sound, @NotNull SoundCategory category, @NotNull Location loc, float volume, float pitch) {
        Preconditions.checkNotNull((Object)sound, (Object)"The played sound cannot be null!");
        Preconditions.checkNotNull((Object)category, (Object)"The category cannot be null!");
        Preconditions.checkNotNull((Object)loc, (Object)"The location cannot be null!");
        this.sound = sound;
        this.category = category;
        this.location = loc;
        this.volume = volume;
        this.pitch = pitch;
    }

    @ApiStatus.Internal
    public AudioExperience(@NotNull org.bukkit.Sound sound, @NotNull SoundCategory category, @NotNull Location loc, float volume, float pitch) {
        this(sound.getKey().getKey(), category, loc, volume, pitch);
    }

    @ApiStatus.Internal
    public AudioExperience(@NotNull Sound sound, @NotNull Location loc) {
        String string = sound.name().asString();
        this(string, switch (sound.source()) {
            default -> throw new IncompatibleClassChangeError();
            case Sound.Source.MASTER -> SoundCategory.MASTER;
            case Sound.Source.MUSIC -> SoundCategory.MUSIC;
            case Sound.Source.RECORD -> SoundCategory.RECORDS;
            case Sound.Source.WEATHER -> SoundCategory.WEATHER;
            case Sound.Source.BLOCK -> SoundCategory.BLOCKS;
            case Sound.Source.HOSTILE -> SoundCategory.HOSTILE;
            case Sound.Source.NEUTRAL -> SoundCategory.NEUTRAL;
            case Sound.Source.PLAYER -> SoundCategory.PLAYERS;
            case Sound.Source.AMBIENT -> SoundCategory.AMBIENT;
            case Sound.Source.VOICE -> SoundCategory.VOICE;
        }, loc, sound.volume(), sound.pitch());
    }

    @NotNull
    public String getSound() {
        return this.sound;
    }

    @NotNull
    public SoundCategory getCategory() {
        return this.category;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Sound.Source getSource() {
        return this.category.soundSource();
    }

    @NotNull
    public Location getLocation() {
        return this.location;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }
}

