/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.tags;

import be.seeseemelk.mockbukkit.tags.TagMisconfigurationException;
import be.seeseemelk.mockbukkit.tags.TagParser;
import be.seeseemelk.mockbukkit.tags.TagRegistry;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.jetbrains.annotations.NotNull;

public class TagWrapperMock
implements Tag<Material> {
    @NotNull
    private final TagRegistry registry;
    @NotNull
    private final NamespacedKey key;
    private final Set<Material> materials = new HashSet<Material>();
    private final Set<TagWrapperMock> additionalTags = new HashSet<TagWrapperMock>();

    public TagWrapperMock(@NotNull TagRegistry registry, @NotNull NamespacedKey key) {
        this.registry = registry;
        this.key = key;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @NotNull
    public TagRegistry getRegistry() {
        return this.registry;
    }

    public void reload() throws TagMisconfigurationException, FileNotFoundException {
        this.materials.clear();
        this.additionalTags.clear();
        new TagParser(this).parse((mats, tags) -> {
            this.materials.addAll((Collection<Material>)mats);
            this.additionalTags.addAll((Collection<TagWrapperMock>)tags);
        });
    }

    public boolean isTagged(@NotNull Material item) {
        if (this.materials.contains(item)) {
            return true;
        }
        for (Tag tag : this.additionalTags) {
            if (!tag.isTagged((Keyed)item)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Set<Material> getValues() {
        if (this.additionalTags.isEmpty()) {
            return Collections.unmodifiableSet(this.materials);
        }
        HashSet<Material> mats = new HashSet<Material>(this.materials);
        for (Tag tag : this.additionalTags) {
            mats.addAll(tag.getValues());
        }
        return mats;
    }

    @NotNull
    public Set<TagWrapperMock> getSubTags() {
        return Collections.unmodifiableSet(this.additionalTags);
    }

    @NotNull
    public String toString() {
        return this.key.toString();
    }
}

