/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.AsyncCatcher;
import be.seeseemelk.mockbukkit.CachedServerIconMock;
import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.MockChunkData;
import be.seeseemelk.mockbukkit.MockPlayerList;
import be.seeseemelk.mockbukkit.MockUnsafeValues;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.WorldMock;
import be.seeseemelk.mockbukkit.block.data.BlockDataMock;
import be.seeseemelk.mockbukkit.boss.BossBarMock;
import be.seeseemelk.mockbukkit.boss.KeyedBossBarMock;
import be.seeseemelk.mockbukkit.command.CommandResult;
import be.seeseemelk.mockbukkit.command.ConsoleCommandSenderMock;
import be.seeseemelk.mockbukkit.command.MessageTarget;
import be.seeseemelk.mockbukkit.command.MockCommandMap;
import be.seeseemelk.mockbukkit.configuration.ServerConfiguration;
import be.seeseemelk.mockbukkit.enchantments.EnchantmentsMock;
import be.seeseemelk.mockbukkit.entity.EntityMock;
import be.seeseemelk.mockbukkit.entity.OfflinePlayerMock;
import be.seeseemelk.mockbukkit.entity.PlayerMock;
import be.seeseemelk.mockbukkit.entity.PlayerMockFactory;
import be.seeseemelk.mockbukkit.help.HelpMapMock;
import be.seeseemelk.mockbukkit.inventory.AnvilInventoryMock;
import be.seeseemelk.mockbukkit.inventory.BarrelInventoryMock;
import be.seeseemelk.mockbukkit.inventory.BeaconInventoryMock;
import be.seeseemelk.mockbukkit.inventory.BrewerInventoryMock;
import be.seeseemelk.mockbukkit.inventory.CartographyInventoryMock;
import be.seeseemelk.mockbukkit.inventory.ChestInventoryMock;
import be.seeseemelk.mockbukkit.inventory.DispenserInventoryMock;
import be.seeseemelk.mockbukkit.inventory.DropperInventoryMock;
import be.seeseemelk.mockbukkit.inventory.EnchantingInventoryMock;
import be.seeseemelk.mockbukkit.inventory.EnderChestInventoryMock;
import be.seeseemelk.mockbukkit.inventory.FurnaceInventoryMock;
import be.seeseemelk.mockbukkit.inventory.GrindstoneInventoryMock;
import be.seeseemelk.mockbukkit.inventory.HopperInventoryMock;
import be.seeseemelk.mockbukkit.inventory.InventoryMock;
import be.seeseemelk.mockbukkit.inventory.ItemFactoryMock;
import be.seeseemelk.mockbukkit.inventory.LecternInventoryMock;
import be.seeseemelk.mockbukkit.inventory.LoomInventoryMock;
import be.seeseemelk.mockbukkit.inventory.PlayerInventoryMock;
import be.seeseemelk.mockbukkit.inventory.ShulkerBoxInventoryMock;
import be.seeseemelk.mockbukkit.inventory.SmithingInventoryMock;
import be.seeseemelk.mockbukkit.inventory.StonecutterInventoryMock;
import be.seeseemelk.mockbukkit.inventory.WorkbenchInventoryMock;
import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import be.seeseemelk.mockbukkit.map.MapViewMock;
import be.seeseemelk.mockbukkit.plugin.PluginManagerMock;
import be.seeseemelk.mockbukkit.potion.MockPotionEffectType;
import be.seeseemelk.mockbukkit.profile.PlayerProfileMock;
import be.seeseemelk.mockbukkit.scheduler.BukkitSchedulerMock;
import be.seeseemelk.mockbukkit.scoreboard.CriteriaMock;
import be.seeseemelk.mockbukkit.scoreboard.ScoreboardManagerMock;
import be.seeseemelk.mockbukkit.services.ServicesManagerMock;
import be.seeseemelk.mockbukkit.tags.TagRegistry;
import be.seeseemelk.mockbukkit.tags.TagWrapperMock;
import be.seeseemelk.mockbukkit.tags.TagsMock;
import com.destroystokyo.paper.entity.ai.MobGoals;
import com.destroystokyo.paper.event.player.PlayerConnectionCloseEvent;
import com.destroystokyo.paper.event.server.WhitelistToggleEvent;
import com.google.common.base.Preconditions;
import io.papermc.paper.datapack.DatapackManager;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.Server;
import org.bukkit.StructureType;
import org.bukkit.Tag;
import org.bukkit.Warning;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldCreator;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.PotionBrewer;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.structure.StructureManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerMock
extends Server.Spigot
implements Server {
    private static final Component MOTD = Component.text((String)"A Minecraft Server");
    private static final Component NO_PERMISSION = Component.text((String)"I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", (TextColor)NamedTextColor.RED);
    private final Properties buildProperties = new Properties();
    private final Logger logger = Logger.getLogger("ServerMock");
    private final Thread mainThread = Thread.currentThread();
    private final MockUnsafeValues unsafe = new MockUnsafeValues();
    private final Map<String, TagRegistry> materialTags = new HashMap<String, TagRegistry>();
    private final Set<EntityMock> entities = new HashSet<EntityMock>();
    private final List<World> worlds = new ArrayList<World>();
    private final List<Recipe> recipes = new LinkedList<Recipe>();
    private final Map<NamespacedKey, KeyedBossBarMock> bossBars = new HashMap<NamespacedKey, KeyedBossBarMock>();
    private final ItemFactoryMock factory = new ItemFactoryMock();
    private final PlayerMockFactory playerFactory = new PlayerMockFactory(this);
    private final PluginManagerMock pluginManager = new PluginManagerMock(this);
    private final ScoreboardManagerMock scoreboardManager = new ScoreboardManagerMock();
    private final Map<String, Criteria> criteria = new HashMap<String, Criteria>();
    private final BukkitSchedulerMock scheduler = new BukkitSchedulerMock();
    private final ServicesManagerMock servicesManager = new ServicesManagerMock();
    private final MockPlayerList playerList = new MockPlayerList();
    private final MockCommandMap commandMap = new MockCommandMap(this);
    private final HelpMapMock helpMap = new HelpMapMock();
    private final StandardMessenger messenger = new StandardMessenger();
    private final Map<Integer, MapViewMock> mapViews = new HashMap<Integer, MapViewMock>();
    private CachedServerIconMock serverIcon = new CachedServerIconMock(null);
    private int nextMapId = 1;
    private GameMode defaultGameMode = GameMode.SURVIVAL;
    private ConsoleCommandSenderMock consoleSender;
    private int spawnRadius = 16;
    @NotNull
    private Warning.WarningState warningState = Warning.WarningState.DEFAULT;
    private boolean isWhitelistEnabled = false;
    private boolean isWhitelistEnforced = false;
    @NotNull
    private final Set<OfflinePlayer> whitelistedPlayers = new LinkedHashSet<OfflinePlayer>();
    @NotNull
    private final ServerConfiguration serverConfiguration = new ServerConfiguration();

    public ServerMock() {
        ServerMock.registerSerializables();
        this.createPotionEffectTypes();
        TagsMock.loadDefaultTags(this, true);
        EnchantmentsMock.registerDefaultEnchantments();
        try {
            InputStream stream = ClassLoader.getSystemResourceAsStream("logger.properties");
            LogManager.getLogManager().readConfiguration(stream);
        }
        catch (IOException e) {
            this.logger.warning("Could not load file logger.properties");
        }
        this.logger.setLevel(Level.ALL);
        try {
            this.buildProperties.load(ClassLoader.getSystemResourceAsStream("build.properties"));
        }
        catch (IOException | NullPointerException e) {
            this.logger.warning("Could not load build properties");
        }
    }

    public boolean isOnMainThread() {
        return this.mainThread.equals(Thread.currentThread());
    }

    public void registerEntity(@NotNull EntityMock entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null");
        AsyncCatcher.catchOp("entity add");
        this.entities.add(entity);
    }

    public void unregisterEntity(@NotNull EntityMock entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null");
        Preconditions.checkArgument((!entity.isValid() ? 1 : 0) != 0, (Object)"Entity is not marked for removal");
        AsyncCatcher.catchOp("entity remove");
        this.entities.remove(entity);
    }

    @NotNull
    public Set<EntityMock> getEntities() {
        return Collections.unmodifiableSet(this.entities);
    }

    public void addPlayer(@NotNull PlayerMock player) {
        AsyncCatcher.catchOp("player add");
        this.playerList.addPlayer(player);
        CountDownLatch conditionLatch = new CountDownLatch(1);
        InetSocketAddress address = player.getAddress();
        AsyncPlayerPreLoginEvent preLoginEvent = new AsyncPlayerPreLoginEvent(player.getName(), address.getAddress(), player.getUniqueId());
        this.getPluginManager().callEventAsynchronously(preLoginEvent, e -> conditionLatch.countDown());
        try {
            conditionLatch.await();
        }
        catch (InterruptedException e2) {
            this.getLogger().severe("Interrupted while waiting for AsyncPlayerPreLoginEvent! " + (StringUtils.isEmpty((CharSequence)e2.getMessage()) ? "" : e2.getMessage()));
            Thread.currentThread().interrupt();
        }
        PlayerLoginEvent playerLoginEvent = new PlayerLoginEvent((Player)player, address.getHostString(), address.getAddress());
        Bukkit.getPluginManager().callEvent((Event)playerLoginEvent);
        Component joinMessage = MiniMessage.miniMessage().deserialize("<name> has joined the Server!", (TagResolver)Placeholder.component((String)"name", (ComponentLike)player.displayName()));
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent((Player)player, joinMessage);
        Bukkit.getPluginManager().callEvent((Event)playerJoinEvent);
        if (this.isWhitelistEnabled && !this.whitelistedPlayers.contains(player)) {
            PlayerConnectionCloseEvent playerConnectionCloseEvent = new PlayerConnectionCloseEvent(player.getUniqueId(), player.getName(), player.getAddress().getAddress(), false);
            this.getPluginManager().callEvent((Event)playerConnectionCloseEvent);
            this.playerList.disconnectPlayer(player);
            return;
        }
        this.registerEntity(player);
    }

    @NotNull
    public PlayerMock addPlayer() {
        AsyncCatcher.catchOp("player add");
        PlayerMock player = this.playerFactory.createRandomPlayer();
        this.addPlayer(player);
        return player;
    }

    @NotNull
    public PlayerMock addPlayer(@NotNull String name) {
        AsyncCatcher.catchOp("player add");
        PlayerMock player = new PlayerMock(this, name);
        this.addPlayer(player);
        return player;
    }

    public void setPlayers(int num) {
        AsyncCatcher.catchOp("set players");
        this.playerList.clearOnlinePlayers();
        for (int i = 0; i < num; ++i) {
            this.addPlayer();
        }
    }

    public void setOfflinePlayers(int num) {
        AsyncCatcher.catchOp("set offline players");
        this.playerList.clearOfflinePlayers();
        for (PlayerMock playerMock : this.getOnlinePlayers()) {
            this.playerList.addPlayer(playerMock);
        }
        for (int i = 0; i < num; ++i) {
            OfflinePlayerMock offlinePlayerMock = this.playerFactory.createRandomOfflinePlayer();
            this.playerList.addOfflinePlayer(offlinePlayerMock);
        }
    }

    @NotNull
    public PlayerMock getPlayer(int num) {
        return this.playerList.getPlayer(num);
    }

    @NotNull
    public MockPlayerList getPlayerList() {
        return this.playerList;
    }

    @Nullable
    public UUID getPlayerUniqueId(@NotNull String playerName) {
        return this.playerList.getOfflinePlayer(playerName).getUniqueId();
    }

    @NotNull
    public WorldMock addSimpleWorld(String name) {
        AsyncCatcher.catchOp("world creation");
        WorldMock world = new WorldMock();
        world.setName(name);
        this.worlds.add(world);
        return world;
    }

    public void addWorld(WorldMock world) {
        AsyncCatcher.catchOp("world add");
        this.worlds.add(world);
    }

    @NotNull
    public CommandResult executeConsole(@NotNull Command command, String ... args) {
        return this.execute(command, (CommandSender)this.getConsoleSender(), args);
    }

    @NotNull
    public CommandResult executeConsole(@NotNull String command, String ... args) {
        return this.executeConsole(this.getCommandMap().getCommand(command), args);
    }

    @NotNull
    public CommandResult executePlayer(@NotNull Command command, String ... args) {
        AsyncCatcher.catchOp("command dispatch");
        if (this.playerList.isSomeoneOnline()) {
            return this.execute(command, (CommandSender)this.getPlayer(0), args);
        }
        throw new IllegalStateException("Need at least one player to run the command");
    }

    @NotNull
    public CommandResult executePlayer(@NotNull String command, String ... args) {
        return this.executePlayer(this.getCommandMap().getCommand(command), args);
    }

    @NotNull
    public CommandResult execute(@NotNull Command command, CommandSender sender, String ... args) {
        AsyncCatcher.catchOp("command dispatch");
        if (!(sender instanceof MessageTarget)) {
            throw new IllegalArgumentException("Only a MessageTarget can be the sender of the command");
        }
        boolean status = command.execute(sender, command.getName(), args);
        return new CommandResult(status, (MessageTarget)sender);
    }

    @NotNull
    public CommandResult execute(@NotNull String command, CommandSender sender, String ... args) {
        AsyncCatcher.catchOp("command dispatch");
        return this.execute(this.getCommandMap().getCommand(command), sender, args);
    }

    @NotNull
    public String getName() {
        return "ServerMock";
    }

    @NotNull
    public String getVersion() {
        return String.format("MockBukkit (MC: %s)", this.getMinecraftVersion());
    }

    @NotNull
    public String getBukkitVersion() {
        Preconditions.checkNotNull((Object)this.buildProperties, (Object)"Failed to load build properties!");
        String apiVersion = this.buildProperties.getProperty("full-api-version");
        Preconditions.checkNotNull((Object)apiVersion, (Object)"Failed to get full-api-version from the build properties!");
        return apiVersion;
    }

    @NotNull
    public String getMinecraftVersion() {
        return this.getBukkitVersion().split("-")[0];
    }

    @NotNull
    public Collection<? extends PlayerMock> getOnlinePlayers() {
        return this.playerList.getOnlinePlayers();
    }

    public OfflinePlayer @NotNull [] getOfflinePlayers() {
        return this.playerList.getOfflinePlayers();
    }

    @Nullable
    public OfflinePlayer getOfflinePlayerIfCached(@NotNull String name) {
        throw new UnimplementedOperationException();
    }

    public Player getPlayer(@NotNull String name) {
        return this.playerList.getPlayer(name);
    }

    public Player getPlayerExact(@NotNull String name) {
        return this.playerList.getPlayerExact(name);
    }

    @NotNull
    public List<Player> matchPlayer(@NotNull String name) {
        return this.playerList.matchPlayer(name);
    }

    public Player getPlayer(@NotNull UUID id) {
        return this.playerList.getPlayer(id);
    }

    @NotNull
    public PluginManagerMock getPluginManager() {
        return this.pluginManager;
    }

    @NotNull
    public MockCommandMap getCommandMap() {
        return this.commandMap;
    }

    public PluginCommand getPluginCommand(@NotNull String name) {
        Command command = this.getCommandMap().getCommand(name);
        return command instanceof PluginCommand ? (PluginCommand)command : null;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public ConsoleCommandSenderMock getConsoleSender() {
        if (this.consoleSender == null) {
            this.consoleSender = new ConsoleCommandSenderMock();
        }
        return this.consoleSender;
    }

    @NotNull
    public CommandSender createCommandSender(@NotNull Consumer<? super Component> feedback) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public InventoryMock createInventory(InventoryHolder owner, @NotNull InventoryType type, String title, int size) {
        Preconditions.checkArgument((boolean)type.isCreatable(), (Object)("Inventory Type '" + type + "' is not creatable!"));
        switch (type) {
            case CHEST: {
                return new ChestInventoryMock(owner, size > 0 ? size : 27);
            }
            case DISPENSER: {
                return new DispenserInventoryMock(owner);
            }
            case DROPPER: {
                return new DropperInventoryMock(owner);
            }
            case PLAYER: {
                if (owner instanceof HumanEntity) {
                    HumanEntity he = (HumanEntity)owner;
                    return new PlayerInventoryMock(he);
                }
                throw new IllegalArgumentException("Cannot create a Player Inventory for: " + owner);
            }
            case ENDER_CHEST: {
                return new EnderChestInventoryMock(owner);
            }
            case HOPPER: {
                return new HopperInventoryMock(owner);
            }
            case SHULKER_BOX: {
                return new ShulkerBoxInventoryMock(owner);
            }
            case BARREL: {
                return new BarrelInventoryMock(owner);
            }
            case LECTERN: {
                return new LecternInventoryMock(owner);
            }
            case GRINDSTONE: {
                return new GrindstoneInventoryMock(owner);
            }
            case STONECUTTER: {
                return new StonecutterInventoryMock(owner);
            }
            case CARTOGRAPHY: {
                return new CartographyInventoryMock(owner);
            }
            case SMOKER: 
            case FURNACE: 
            case BLAST_FURNACE: {
                return new FurnaceInventoryMock(owner);
            }
            case LOOM: {
                return new LoomInventoryMock(owner);
            }
            case ANVIL: {
                return new AnvilInventoryMock(owner);
            }
            case SMITHING: {
                return new SmithingInventoryMock(owner);
            }
            case BEACON: {
                return new BeaconInventoryMock(owner);
            }
            case WORKBENCH: {
                return new WorkbenchInventoryMock(owner);
            }
            case ENCHANTING: {
                return new EnchantingInventoryMock(owner);
            }
            case BREWING: {
                return new BrewerInventoryMock(owner);
            }
        }
        throw new UnimplementedOperationException("Inventory type not yet supported");
    }

    @NotNull
    public InventoryMock createInventory(InventoryHolder owner, @NotNull InventoryType type) {
        return this.createInventory(owner, type, "Inventory");
    }

    @NotNull
    public InventoryMock createInventory(@Nullable InventoryHolder owner, @NotNull InventoryType type, @NotNull Component title) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public InventoryMock createInventory(InventoryHolder owner, @NotNull InventoryType type, String title) {
        return this.createInventory(owner, type, title, -1);
    }

    @NotNull
    public InventoryMock createInventory(InventoryHolder owner, int size) {
        return this.createInventory(owner, size, "Inventory");
    }

    @NotNull
    public InventoryMock createInventory(@Nullable InventoryHolder owner, int size, @NotNull Component title) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public InventoryMock createInventory(InventoryHolder owner, int size, String title) {
        return this.createInventory(owner, InventoryType.CHEST, title, size);
    }

    @NotNull
    public Merchant createMerchant(@Nullable Component title) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemFactoryMock getItemFactory() {
        return this.factory;
    }

    @NotNull
    public List<World> getWorlds() {
        return new ArrayList<World>(this.worlds);
    }

    public boolean isTickingWorlds() {
        throw new UnimplementedOperationException();
    }

    public World getWorld(String name) {
        return this.worlds.stream().filter(world -> world.getName().equals(name)).findAny().orElse(null);
    }

    public World getWorld(UUID uid) {
        return this.worlds.stream().filter(world -> world.getUID().equals(uid)).findAny().orElse(null);
    }

    @Nullable
    public World getWorld(@NotNull NamespacedKey worldKey) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public WorldBorder createWorldBorder() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BukkitSchedulerMock getScheduler() {
        return this.scheduler;
    }

    public int getMaxPlayers() {
        return this.playerList.getMaxPlayers();
    }

    public void setMaxPlayers(int maxPlayers) {
        this.playerList.setMaxPlayers(maxPlayers);
    }

    @NotNull
    public Set<String> getIPBans() {
        return this.playerList.getIPBans().getBanEntries().stream().map(BanEntry::getTarget).collect(Collectors.toSet());
    }

    public void banIP(@NotNull String address) {
        this.playerList.getIPBans().addBan(address, null, null, null);
    }

    public void unbanIP(@NotNull String address) {
        this.playerList.getIPBans().pardon(address);
    }

    @NotNull
    public BanList getBanList(@NotNull BanList.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case BanList.Type.IP -> this.playerList.getIPBans();
            case BanList.Type.NAME -> this.playerList.getProfileBans();
        };
    }

    @NotNull
    public Set<OfflinePlayer> getOperators() {
        return this.playerList.getOperators();
    }

    @NotNull
    public GameMode getDefaultGameMode() {
        return this.defaultGameMode;
    }

    public void setDefaultGameMode(GameMode mode) {
        this.defaultGameMode = mode;
    }

    @Deprecated
    public int broadcastMessage(@NotNull String message) {
        Collection<? extends PlayerMock> players = this.getOnlinePlayers();
        for (Player player : players) {
            player.sendMessage(message);
        }
        return players.size();
    }

    @Deprecated
    public int broadcast(@NotNull String message, @NotNull String permission) {
        Collection<? extends PlayerMock> players = this.getOnlinePlayers();
        int count = 0;
        for (Player player : players) {
            if (!player.hasPermission(permission)) continue;
            player.sendMessage(message);
            ++count;
        }
        return count;
    }

    public int broadcast(@NotNull Component message) {
        Collection<? extends PlayerMock> players = this.getOnlinePlayers();
        for (Player player : players) {
            player.sendMessage(message);
        }
        return players.size();
    }

    public int broadcast(@NotNull Component message, @NotNull String permission) {
        Collection<? extends PlayerMock> players = this.getOnlinePlayers();
        int count = 0;
        for (Player player : players) {
            if (!player.hasPermission(permission)) continue;
            player.sendMessage(message);
            ++count;
        }
        return count;
    }

    public static void registerSerializables() {
        ConfigurationSerialization.registerClass(ItemMetaMock.class);
    }

    public boolean addRecipe(Recipe recipe) {
        this.recipes.add(recipe);
        return true;
    }

    @NotNull
    public List<Recipe> getRecipesFor(@NotNull ItemStack item) {
        return this.recipes.stream().filter(recipe -> {
            ItemStack result = recipe.getResult();
            return result.getType() == item.getType() && result.getItemMeta().equals(item.getItemMeta());
        }).collect(Collectors.toList());
    }

    public Recipe getRecipe(NamespacedKey key) {
        for (Recipe recipe : this.recipes) {
            if (!(recipe instanceof Keyed) || !((Keyed)recipe).getKey().equals((Object)key)) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public Recipe getCraftingRecipe(@NotNull ItemStack[] craftingMatrix, @NotNull World world) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemStack craftItem(@NotNull ItemStack[] craftingMatrix, @NotNull World world, @NotNull Player player) {
        throw new UnimplementedOperationException();
    }

    public boolean removeRecipe(NamespacedKey key) {
        Iterator<Recipe> iterator = this.recipeIterator();
        while (iterator.hasNext()) {
            Recipe recipe = iterator.next();
            if (!(recipe instanceof Keyed) || !((Keyed)recipe).getKey().equals((Object)key)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @NotNull
    public Iterator<Recipe> recipeIterator() {
        return this.recipes.iterator();
    }

    public void clearRecipes() {
        this.recipes.clear();
    }

    public boolean dispatchCommand(@NotNull CommandSender sender, @NotNull String commandLine) {
        AsyncCatcher.catchOp("command dispatch");
        String[] commands = commandLine.split(" ");
        String commandLabel = commands[0];
        String[] args = Arrays.copyOfRange(commands, 1, commands.length);
        Command command = this.getCommandMap().getCommand(commandLabel);
        if (command != null) {
            return command.execute(sender, commandLabel, args);
        }
        return false;
    }

    @NotNull
    public List<String> getCommandTabComplete(@NotNull CommandSender sender, @NotNull String commandLine) {
        AsyncCatcher.catchOp("command tabcomplete");
        int idx = commandLine.indexOf(32);
        String commandLabel = commandLine.substring(0, idx);
        String[] args = commandLine.substring(idx + 1).split(" ", -1);
        Command command = this.getCommandMap().getCommand(commandLabel);
        if (command != null) {
            return command.tabComplete(sender, commandLabel, args);
        }
        return Collections.emptyList();
    }

    @NotNull
    public HelpMapMock getHelpMap() {
        return this.helpMap;
    }

    public void sendPluginMessage(@NotNull Plugin source, @NotNull String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        for (Player player : this.getOnlinePlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    @NotNull
    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (Player player : this.getOnlinePlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    public int getPort() {
        throw new UnimplementedOperationException();
    }

    public int getViewDistance() {
        return this.serverConfiguration.getViewDistance();
    }

    public void setViewDistance(int viewDistance) {
        this.serverConfiguration.setViewDistance(viewDistance);
    }

    @NotNull
    public String getIp() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public String getWorldType() {
        return this.serverConfiguration.getLevelType().getKey();
    }

    public void setWorldType(@NotNull ServerConfiguration.LevelType worldType) {
        this.serverConfiguration.setLevelType(worldType);
    }

    public boolean getGenerateStructures() {
        return this.serverConfiguration.isGenerateStructures();
    }

    public void setGenerateStructures(boolean generateStructures) {
        this.serverConfiguration.setGenerateStructures(generateStructures);
    }

    public boolean getAllowEnd() {
        return this.serverConfiguration.isAllowEnd();
    }

    public void setAllowEnd(boolean allowEnd) {
        this.serverConfiguration.setAllowEnd(allowEnd);
    }

    public boolean getAllowNether() {
        return this.serverConfiguration.isAllowNether();
    }

    public void setAllowNether(boolean allowNether) {
        this.serverConfiguration.setAllowNether(allowNether);
    }

    @NotNull
    public String getResourcePack() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public String getResourcePackHash() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public String getResourcePackPrompt() {
        throw new UnimplementedOperationException();
    }

    public boolean isResourcePackRequired() {
        throw new UnimplementedOperationException();
    }

    public boolean hasWhitelist() {
        return this.isWhitelistEnabled;
    }

    public void setWhitelist(boolean value) {
        this.isWhitelistEnabled = value;
        WhitelistToggleEvent event = new WhitelistToggleEvent(value);
        this.getPluginManager().callEvent((Event)event);
    }

    public boolean isWhitelistEnforced() {
        return this.isWhitelistEnforced;
    }

    public void setWhitelistEnforced(boolean value) {
        this.isWhitelistEnforced = value;
    }

    @NotNull
    public Set<OfflinePlayer> getWhitelistedPlayers() {
        return this.whitelistedPlayers;
    }

    public void reloadWhitelist() {
        if (!this.isWhitelistEnforced && this.isWhitelistEnabled) {
            return;
        }
        MockBukkit.getMock().getOnlinePlayers().forEach(p -> {
            if (!MockBukkit.getMock().getWhitelistedPlayers().contains(p)) {
                p.kick();
            }
        });
    }

    @NotNull
    public String getUpdateFolder() {
        return this.serverConfiguration.getUpdateFolder();
    }

    public void setUpdateFolder(@NotNull String updateFolder) {
        this.serverConfiguration.setUpdateFolder(updateFolder);
    }

    @NotNull
    public File getUpdateFolderFile() {
        return new File(this.getPluginsFolder(), this.getUpdateFolder());
    }

    public long getConnectionThrottle() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public int getTicksPerAnimalSpawns() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public int getTicksPerMonsterSpawns() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ServicesManagerMock getServicesManager() {
        return this.servicesManager;
    }

    public World createWorld(@NotNull WorldCreator creator) {
        WorldMock world = new WorldMock(creator);
        this.addWorld(world);
        return world;
    }

    public boolean unloadWorld(String name, boolean save) {
        throw new UnimplementedOperationException();
    }

    public boolean unloadWorld(World world, boolean save) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public MapViewMock createMap(@NotNull World world) {
        MapViewMock mapView = new MapViewMock(world, this.nextMapId++);
        this.mapViews.put(mapView.getId(), mapView);
        new MapInitializeEvent((MapView)mapView).callEvent();
        return mapView;
    }

    public void reload() {
        throw new UnimplementedOperationException();
    }

    public void reloadData() {
        throw new UnimplementedOperationException();
    }

    public void savePlayers() {
        throw new UnimplementedOperationException();
    }

    public void resetRecipes() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Map<String, String[]> getCommandAliases() {
        throw new UnimplementedOperationException();
    }

    public int getSpawnRadius() {
        return this.spawnRadius;
    }

    public void setSpawnRadius(int spawnRadius) {
        this.spawnRadius = spawnRadius;
    }

    @Deprecated(forRemoval=true)
    public boolean shouldSendChatPreviews() {
        return this.serverConfiguration.shouldSendChatPreviews();
    }

    @Deprecated(forRemoval=true)
    public void setShouldSendChatPreviews(boolean shouldSendChatPreviews) {
        this.serverConfiguration.setShouldSendChatPreviews(shouldSendChatPreviews);
    }

    public boolean isEnforcingSecureProfiles() {
        return this.serverConfiguration.isEnforceSecureProfiles() && this.getOnlineMode();
    }

    public void setEnforcingSecureProfiles(boolean enforcingSecureProfiles) {
        this.serverConfiguration.setEnforceSecureProfiles(enforcingSecureProfiles);
    }

    public boolean getOnlineMode() {
        return this.serverConfiguration.isOnlineMode();
    }

    public void setOnlineMode(boolean onlineMode) {
        this.serverConfiguration.setOnlineMode(onlineMode);
    }

    public boolean getAllowFlight() {
        return this.serverConfiguration.isAllowFlight();
    }

    public void setAllowFlight(boolean allowFlight) {
        this.serverConfiguration.setAllowFlight(allowFlight);
    }

    public boolean isHardcore() {
        return this.serverConfiguration.isHardcore();
    }

    public void setHardcore(boolean hardcore) {
        this.serverConfiguration.setHardcore(hardcore);
    }

    public void shutdown() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public OfflinePlayer getOfflinePlayer(@NotNull String name) {
        return this.playerList.getOfflinePlayer(name);
    }

    @NotNull
    public OfflinePlayer getOfflinePlayer(@NotNull UUID id) {
        OfflinePlayer player = this.playerList.getOfflinePlayer(id);
        if (player != null) {
            return player;
        }
        return this.playerFactory.createOfflinePlayer(id);
    }

    @NotNull
    public Set<OfflinePlayer> getBannedPlayers() {
        return this.getBanList(BanList.Type.NAME).getBanEntries().stream().map(banEntry -> this.getOfflinePlayer(banEntry.getTarget())).collect(Collectors.toSet());
    }

    @NotNull
    public File getWorldContainer() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Messenger getMessenger() {
        return this.messenger;
    }

    @Deprecated
    @NotNull
    public Merchant createMerchant(String title) {
        throw new UnimplementedOperationException();
    }

    public int getMaxChainedNeighborUpdates() {
        return this.serverConfiguration.getMaxChainedNeighbourUpdates();
    }

    public void setMaxChainedNeighborUpdates(int maxChainedNeighborUpdates) {
        this.serverConfiguration.setMaxChainedNeighbourUpdates(maxChainedNeighborUpdates);
    }

    @Deprecated
    public int getMonsterSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public int getAnimalSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public int getWaterAnimalSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public int getAmbientSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    public boolean isPrimaryThread() {
        return this.isOnMainThread();
    }

    @NotNull
    public Component motd() {
        return MOTD;
    }

    @Deprecated
    @NotNull
    public String getMotd() {
        return LegacyComponentSerializer.legacySection().serialize(MOTD);
    }

    @Nullable
    public Component shutdownMessage() {
        return this.serverConfiguration.getShutdownMessage();
    }

    public void setShutdownMessage(@NotNull Component shutdownMessage) {
        this.serverConfiguration.setShutdownMessage(shutdownMessage);
    }

    @Deprecated
    public String getShutdownMessage() {
        return LegacyComponentSerializer.legacySection().serialize(this.serverConfiguration.getShutdownMessage());
    }

    public void setWarningState(@NotNull Warning.WarningState warningState) {
        Preconditions.checkNotNull((Object)warningState, (Object)"warningState cannot be null");
        this.warningState = warningState;
    }

    @NotNull
    public Warning.WarningState getWarningState() {
        return this.warningState;
    }

    @NotNull
    public ScoreboardManagerMock getScoreboardManager() {
        return this.scoreboardManager;
    }

    @NotNull
    public Criteria getScoreboardCriteria(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Scoreboard criteria name cannot be null");
        return this.criteria.computeIfAbsent(name, CriteriaMock::new);
    }

    public void setServerIcon(CachedServerIconMock serverIcon) {
        this.serverIcon = serverIcon;
    }

    public CachedServerIconMock getServerIcon() {
        return this.serverIcon;
    }

    @NotNull
    public CachedServerIconMock loadServerIcon(@NotNull File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"File cannot be null");
        Preconditions.checkArgument((boolean)file.isFile(), (Object)(file + " isn't a file"));
        return this.loadServerIcon(ImageIO.read(file));
    }

    @NotNull
    public CachedServerIconMock loadServerIcon(@NotNull BufferedImage image) throws IOException {
        Preconditions.checkNotNull((Object)image, (Object)"Image cannot be null");
        Preconditions.checkArgument((image.getWidth() == 64 ? 1 : 0) != 0, (Object)"Image must be 64 pixels wide");
        Preconditions.checkArgument((image.getHeight() == 64 ? 1 : 0) != 0, (Object)"Image must be 64 pixels high");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", out);
        String encoded = Base64.getEncoder().encodeToString(out.toByteArray());
        return new CachedServerIconMock("data:image/png;base64," + encoded);
    }

    public void setIdleTimeout(int threshold) {
        throw new UnimplementedOperationException();
    }

    public int getIdleTimeout() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ChunkGenerator.ChunkData createChunkData(@NotNull World world) {
        Preconditions.checkNotNull((Object)world, (Object)"World cannot be null");
        return new MockChunkData(world);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public ChunkGenerator.ChunkData createVanillaChunkData(@NotNull World world, int x, int z) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BossBar createBossBar(@NotNull String title, @NotNull BarColor color, @NotNull BarStyle style, BarFlag ... flags) {
        return new BossBarMock(title, color, style, flags);
    }

    @Nullable
    public Entity getEntity(@NotNull UUID uuid) {
        Preconditions.checkNotNull((Object)uuid, (Object)"uuid cannot be null");
        for (EntityMock entity : this.entities) {
            if (!entity.getUniqueId().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    @NotNull
    public double[] getTPS() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public long[] getTickTimes() {
        throw new UnimplementedOperationException();
    }

    public double getAverageTickTime() {
        throw new UnimplementedOperationException();
    }

    public Advancement getAdvancement(NamespacedKey key) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Iterator<Advancement> advancementIterator() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public MockUnsafeValues getUnsafe() {
        return this.unsafe;
    }

    @NotNull
    public BlockData createBlockData(@NotNull Material material) {
        Preconditions.checkNotNull((Object)material, (Object)"Must provide material");
        return BlockDataMock.mock(material);
    }

    @NotNull
    public BlockData createBlockData(@NotNull Material material, @Nullable Consumer<BlockData> consumer) {
        BlockData blockData = this.createBlockData(material);
        if (consumer != null) {
            consumer.accept(blockData);
        }
        return blockData;
    }

    @NotNull
    public BlockData createBlockData(String data) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BlockData createBlockData(Material material, String data) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Tag<Material> createMaterialTag(@NotNull NamespacedKey key, @NotNull String registryKey, Material ... materials) {
        Preconditions.checkNotNull((Object)key, (Object)"A NamespacedKey must never be null");
        TagRegistry registry = this.materialTags.get(registryKey);
        TagWrapperMock tag = new TagWrapperMock(registry, key);
        registry.getTags().put(key, tag);
        return tag;
    }

    public void addTagRegistry(@NotNull TagRegistry registry) {
        this.materialTags.put(registry.getRegistry(), registry);
    }

    public <T extends Keyed> Tag<T> getTag(String registryKey, NamespacedKey key, Class<T> clazz) {
        Tag tag;
        TagRegistry registry;
        if (clazz == Material.class && (registry = this.materialTags.get(registryKey)) != null && (tag = (Tag)registry.getTags().get(key)) != null) {
            return tag;
        }
        return null;
    }

    private void createPotionEffectTypes() {
        for (PotionEffectType type : PotionEffectType.values()) {
            if (type == null) continue;
            return;
        }
        this.registerPotionEffectType(1, "SPEED", false, 8171462);
        this.registerPotionEffectType(2, "SLOWNESS", false, 5926017);
        this.registerPotionEffectType(3, "HASTE", false, 14270531);
        this.registerPotionEffectType(4, "MINING_FATIGUE", false, 4866583);
        this.registerPotionEffectType(5, "STRENGTH", false, 9643043);
        this.registerPotionEffectType(6, "INSTANT_HEALTH", true, 16262179);
        this.registerPotionEffectType(7, "INSTANT_DAMAGE", true, 4393481);
        this.registerPotionEffectType(8, "JUMP_BOOST", false, 2293580);
        this.registerPotionEffectType(9, "NAUSEA", false, 5578058);
        this.registerPotionEffectType(10, "REGENERATION", false, 13458603);
        this.registerPotionEffectType(11, "RESISTANCE", false, 10044730);
        this.registerPotionEffectType(12, "FIRE_RESISTANCE", false, 14981690);
        this.registerPotionEffectType(13, "WATER_BREATHING", false, 3035801);
        this.registerPotionEffectType(14, "INVISIBILITY", false, 8356754);
        this.registerPotionEffectType(15, "BLINDNESS", false, 2039587);
        this.registerPotionEffectType(16, "NIGHT_VISION", false, 0x1F1FA1);
        this.registerPotionEffectType(17, "HUNGER", false, 5797459);
        this.registerPotionEffectType(18, "WEAKNESS", false, 0x484D48);
        this.registerPotionEffectType(19, "POISON", false, 5149489);
        this.registerPotionEffectType(20, "WITHER", false, 3484199);
        this.registerPotionEffectType(21, "HEALTH_BOOST", false, 16284963);
        this.registerPotionEffectType(22, "ABSORPTION", false, 0x2552A5);
        this.registerPotionEffectType(23, "SATURATION", true, 16262179);
        this.registerPotionEffectType(24, "GLOWING", false, 9740385);
        this.registerPotionEffectType(25, "LEVITATION", false, 0xCEFFFF);
        this.registerPotionEffectType(26, "LUCK", false, 0x339900);
        this.registerPotionEffectType(27, "UNLUCK", false, 12624973);
        this.registerPotionEffectType(28, "SLOW_FALLING", false, 16773073);
        this.registerPotionEffectType(29, "CONDUIT_POWER", false, 1950417);
        this.registerPotionEffectType(30, "DOLPHINS_GRACE", false, 8954814);
        this.registerPotionEffectType(31, "BAD_OMEN", false, 745784);
        this.registerPotionEffectType(32, "HERO_OF_THE_VILLAGE", false, 0x44FF44);
        this.registerPotionEffectType(33, "DARKNESS", false, 2696993);
        PotionEffectType.stopAcceptingRegistrations();
    }

    private void registerPotionEffectType(int id, @NotNull String name, boolean instant, int rgb) {
        NamespacedKey key = NamespacedKey.minecraft((String)name.toLowerCase(Locale.ROOT));
        MockPotionEffectType type = new MockPotionEffectType(key, id, name, instant, Color.fromRGB((int)rgb));
        PotionEffectType.registerPotionEffectType((PotionEffectType)type);
    }

    public LootTable getLootTable(NamespacedKey key) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemStack createExplorerMap(World world, Location location, StructureType structureType) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemStack createExplorerMap(World world, Location location, StructureType structureType, int radius, boolean findUnexplored) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public KeyedBossBar createBossBar(@NotNull NamespacedKey key, @NotNull String title, @NotNull BarColor color, @NotNull BarStyle style, BarFlag ... flags) {
        Preconditions.checkNotNull((Object)key, (Object)"A NamespacedKey must never be null");
        KeyedBossBarMock bar = new KeyedBossBarMock(key, title, color, style, flags);
        this.bossBars.put(key, bar);
        return bar;
    }

    @NotNull
    public Iterator<KeyedBossBar> getBossBars() {
        return this.bossBars.values().stream().map(bossbar -> bossbar).iterator();
    }

    public KeyedBossBar getBossBar(NamespacedKey key) {
        Preconditions.checkNotNull((Object)key, (Object)"A NamespacedKey must never be null");
        return this.bossBars.get(key);
    }

    public boolean removeBossBar(NamespacedKey key) {
        Preconditions.checkNotNull((Object)key, (Object)"A NamespacedKey must never be null");
        return this.bossBars.remove(key, this.bossBars.get(key));
    }

    @NotNull
    public List<Entity> selectEntities(CommandSender sender, String selector) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public StructureManager getStructureManager() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public <T extends Keyed> Registry<T> getRegistry(@NotNull Class<T> tClass) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public MapViewMock getMap(int id) {
        return this.mapViews.get(id);
    }

    @NotNull
    public <T extends Keyed> Iterable<Tag<T>> getTags(String registry, Class<T> clazz) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public int getTicksPerWaterSpawns() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public int getTicksPerAmbientSpawns() {
        throw new UnimplementedOperationException();
    }

    protected long getCurrentServerTime() {
        return System.currentTimeMillis();
    }

    public int getTicksPerWaterAmbientSpawns() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public int getTicksPerWaterUndergroundCreatureSpawns() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public int getWaterAmbientSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public int getWaterUndergroundCreatureSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    public int getMaxWorldSize() {
        return this.serverConfiguration.getMaxWorldSize();
    }

    public void setMaxWorldSize(int maxWorldSize) {
        this.serverConfiguration.setMaxWorldSize(maxWorldSize);
    }

    public int getSimulationDistance() {
        return this.serverConfiguration.getSimulationDistance();
    }

    public void setSimulationDistance(int simulationDistance) {
        this.serverConfiguration.setSimulationDistance(simulationDistance);
    }

    public boolean getHideOnlinePlayers() {
        return this.serverConfiguration.isHideOnlinePlayers();
    }

    public void setHideOnlinePlayers(boolean hideOnlinePlayers) {
        this.serverConfiguration.setHideOnlinePlayers(hideOnlinePlayers);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Server.Spigot spigot() {
        return this;
    }

    public void reloadPermissions() {
        throw new UnimplementedOperationException();
    }

    public boolean reloadCommandAliases() {
        throw new UnimplementedOperationException();
    }

    public boolean suggestPlayerNamesWhenNullTabCompletions() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public String getPermissionMessage() {
        return this.unsafe.legacyComponentSerializer().serialize(NO_PERMISSION);
    }

    @NotNull
    public Component permissionMessage() {
        return NO_PERMISSION;
    }

    @NotNull
    public PlayerProfileMock createProfile(@NotNull UUID uuid) {
        return this.createProfile(uuid, null);
    }

    @NotNull
    public PlayerProfileMock createProfile(@NotNull String name) {
        return this.createProfile(null, name);
    }

    @NotNull
    public PlayerProfileMock createProfile(@Nullable UUID uuid, @Nullable String name) {
        return new PlayerProfileMock(name, uuid);
    }

    @NotNull
    public PlayerProfileMock createProfileExact(@Nullable UUID uuid, @Nullable String name) {
        return new PlayerProfileMock(name, uuid);
    }

    public int getCurrentTick() {
        throw new UnimplementedOperationException();
    }

    public boolean isStopping() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public MobGoals getMobGoals() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public DatapackManager getDatapackManager() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public YamlConfiguration getConfig() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void broadcast(@NotNull BaseComponent component) {
        for (Player player : this.getOnlinePlayers()) {
            player.spigot().sendMessage(component);
        }
    }

    @Deprecated
    public void broadcast(BaseComponent ... components) {
        for (Player player : this.getOnlinePlayers()) {
            player.spigot().sendMessage(components);
        }
    }

    public void restart() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public int getTicksPerSpawns(@NotNull SpawnCategory spawnCategory) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public PlayerProfileMock createPlayerProfile(@Nullable UUID uniqueId, @Nullable String name) {
        return new PlayerProfileMock(name, uniqueId);
    }

    @Deprecated
    @NotNull
    public PlayerProfileMock createPlayerProfile(@NotNull UUID uniqueId) {
        return this.createPlayerProfile(uniqueId, null);
    }

    @Deprecated
    @NotNull
    public PlayerProfileMock createPlayerProfile(@NotNull String name) {
        return this.createPlayerProfile(null, name);
    }

    public int getSpawnLimit(@NotNull SpawnCategory spawnCategory) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public PotionBrewer getPotionBrewer() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public File getPluginsFolder() {
        try {
            return this.getPluginManager().getParentTemporaryDirectory();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public Iterable<? extends Audience> audiences() {
        throw new UnimplementedOperationException();
    }
}

