/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.attribute;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.jetbrains.annotations.NotNull;

public class AttributeInstanceMock
implements AttributeInstance {
    @NotNull
    private final Attribute attribute;
    private final double defaultValue;
    private double value;
    @NotNull
    private final List<AttributeModifier> modifiers;

    public AttributeInstanceMock(@NotNull Attribute attribute, double value) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        this.attribute = attribute;
        this.defaultValue = value;
        this.value = value;
        this.modifiers = new ArrayList<AttributeModifier>();
    }

    @NotNull
    public Attribute getAttribute() {
        return this.attribute;
    }

    public double getBaseValue() {
        return this.value;
    }

    public void setBaseValue(double value) {
        this.value = value;
    }

    @NotNull
    public Collection<AttributeModifier> getModifiers() {
        return this.modifiers;
    }

    public void addModifier(@NotNull AttributeModifier modifier) {
        Preconditions.checkNotNull((Object)modifier, (Object)"Modifier cannot be null");
        this.modifiers.add(modifier);
    }

    public void removeModifier(@NotNull AttributeModifier modifier) {
        Preconditions.checkNotNull((Object)modifier, (Object)"Modifier cannot be null");
        this.modifiers.remove(modifier);
    }

    public double getValue() {
        return this.getBaseValue();
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }
}

