/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.block.state.TileStateMock;
import java.util.Collection;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Beacon;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;

public class BeaconMock
extends TileStateMock
implements Beacon {
    @Nullable
    private String lock;
    @Nullable
    private Component customName;
    private int tier;
    @Nullable
    private PotionEffectType primaryEffect;
    @Nullable
    private PotionEffectType secondaryEffect;
    private double effectRange = -1.0;

    public BeaconMock(@NotNull Material material) {
        super(material);
        this.checkType(material, Material.BEACON);
    }

    protected BeaconMock(@NotNull Block block) {
        super(block);
        this.checkType(block, Material.BEACON);
    }

    protected BeaconMock(@NotNull BeaconMock state) {
        super(state);
        this.lock = state.lock;
        this.customName = state.customName;
        this.tier = state.tier;
        this.primaryEffect = state.primaryEffect;
        this.secondaryEffect = state.secondaryEffect;
        this.effectRange = state.effectRange;
    }

    @Override
    @NotNull
    public BlockState getSnapshot() {
        return new BeaconMock(this);
    }

    @NotNull
    public Collection<LivingEntity> getEntitiesInRange() {
        if (!this.isPlaced()) {
            throw new IllegalStateException("Cannot get entities in range of a beacon that is not placed");
        }
        return this.getWorld().getLivingEntities().stream().filter(Player.class::isInstance).filter(p -> p.getLocation().distance(this.getLocation()) < this.getEffectRange()).toList();
    }

    public void updateTier() {
        this.tier = this.calculateBase();
    }

    @Test
    public void setTier(int tier) {
        this.tier = Math.max(1, Math.min(4, tier));
    }

    public int getTier() {
        return this.tier;
    }

    @Nullable
    public PotionEffect getPrimaryEffect() {
        return this.primaryEffect != null ? new PotionEffect(this.primaryEffect, this.calculateEffectDuration(), this.calculateEffectAmplifier()) : null;
    }

    public void setPrimaryEffect(@Nullable PotionEffectType effect) {
        this.primaryEffect = effect;
    }

    @Nullable
    public PotionEffect getSecondaryEffect() {
        return this.hasSecondaryEffect() ? new PotionEffect(this.secondaryEffect, this.calculateEffectDuration(), this.calculateEffectAmplifier()) : null;
    }

    public void setSecondaryEffect(@Nullable PotionEffectType effect) {
        this.secondaryEffect = effect;
    }

    public double getEffectRange() {
        return this.effectRange < 0.0 ? (double)(this.getTier() * 10 + 10) : this.effectRange;
    }

    public void setEffectRange(double range) {
        this.effectRange = range;
    }

    public void resetEffectRange() {
        this.effectRange = -1.0;
    }

    @Nullable
    public Component customName() {
        return this.customName;
    }

    public void customName(@Nullable Component customName) {
        this.customName = customName;
    }

    @Nullable
    public String getCustomName() {
        return this.customName == null ? null : LegacyComponentSerializer.legacySection().serialize(this.customName);
    }

    public void setCustomName(@Nullable String name) {
        this.customName = name == null ? null : LegacyComponentSerializer.legacySection().deserialize(name);
    }

    public boolean isLocked() {
        return this.lock != null && !this.lock.isEmpty();
    }

    @NotNull
    public String getLock() {
        return this.lock;
    }

    public void setLock(@Nullable String key) {
        this.lock = key;
    }

    private int calculateBase() {
        int level = 0;
        for (int y = this.getY() - 1; y >= this.getY() - 4 && y >= this.getWorld().getMinHeight(); --y) {
            int yOffset = this.getY() - y;
            for (int x = this.getX() - yOffset; x <= this.getX() + yOffset; ++x) {
                for (int z = this.getZ() - yOffset; z <= this.getZ() + yOffset; ++z) {
                    if (Bukkit.getTag((String)"blocks", (NamespacedKey)NamespacedKey.minecraft((String)"beacon_base_blocks"), Material.class).isTagged((Keyed)this.getWorld().getBlockAt(x, y, z).getType())) continue;
                    return level;
                }
            }
            ++level;
        }
        return level;
    }

    private int calculateEffectDuration() {
        return (9 + (this.getTier() << 1)) * 20;
    }

    private int calculateEffectAmplifier() {
        int amp = 0;
        if (this.getTier() >= 4 && this.primaryEffect != null && this.primaryEffect.equals((Object)this.secondaryEffect)) {
            amp = 1;
        }
        return amp;
    }

    private boolean hasSecondaryEffect() {
        return this.getTier() >= 4 && this.primaryEffect != null && !this.primaryEffect.equals((Object)this.secondaryEffect) && this.secondaryEffect != null;
    }
}

