/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.block.state.TileStateMock;
import com.destroystokyo.paper.MaterialTags;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Bed;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BedMock
extends TileStateMock
implements Bed {
    public BedMock(@NotNull Material material) {
        super(material);
        this.checkType(material, (Tag<Material>)MaterialTags.BEDS);
    }

    protected BedMock(@NotNull Block block) {
        super(block);
        this.checkType(block, (Tag<Material>)MaterialTags.BEDS);
    }

    protected BedMock(@NotNull BedMock state) {
        super(state);
    }

    @Nullable
    public DyeColor getColor() {
        return switch (this.getType()) {
            case Material.BLACK_BED -> DyeColor.BLACK;
            case Material.BLUE_BED -> DyeColor.BLUE;
            case Material.BROWN_BED -> DyeColor.BROWN;
            case Material.CYAN_BED -> DyeColor.CYAN;
            case Material.GRAY_BED -> DyeColor.GRAY;
            case Material.GREEN_BED -> DyeColor.GREEN;
            case Material.LIGHT_BLUE_BED -> DyeColor.LIGHT_BLUE;
            case Material.LIGHT_GRAY_BED -> DyeColor.LIGHT_GRAY;
            case Material.LIME_BED -> DyeColor.LIME;
            case Material.MAGENTA_BED -> DyeColor.MAGENTA;
            case Material.ORANGE_BED -> DyeColor.ORANGE;
            case Material.PINK_BED -> DyeColor.PINK;
            case Material.PURPLE_BED -> DyeColor.PURPLE;
            case Material.RED_BED -> DyeColor.RED;
            case Material.WHITE_BED -> DyeColor.WHITE;
            case Material.YELLOW_BED -> DyeColor.YELLOW;
            default -> throw new IllegalArgumentException("Unknown DyeColor for " + this.getType());
        };
    }

    public void setColor(DyeColor color) {
        throw new UnsupportedOperationException("Must set block type to appropriate bed colour");
    }

    @Override
    @NotNull
    public BlockState getSnapshot() {
        return new BedMock(this);
    }
}

