/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.block.state.TileStateMock;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Jukebox;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JukeboxMock
extends TileStateMock
implements Jukebox {
    private ItemStack recordItem;
    private boolean playing;

    public JukeboxMock(@NotNull Material material) {
        super(material);
        this.checkType(material, Material.JUKEBOX);
        this.setRecord(null);
    }

    protected JukeboxMock(@NotNull Block block) {
        super(block);
        this.checkType(block, Material.JUKEBOX);
        this.setRecord(null);
    }

    protected JukeboxMock(@NotNull JukeboxMock state) {
        super(state);
        this.recordItem = state.recordItem;
        this.playing = state.playing;
    }

    @Override
    @NotNull
    public BlockState getSnapshot() {
        return new JukeboxMock(this);
    }

    @NotNull
    public Material getPlaying() {
        return this.recordItem.getType();
    }

    public void setPlaying(@Nullable Material recordType) {
        this.setRecord(new ItemStack(recordType == null ? Material.AIR : recordType));
    }

    @NotNull
    public ItemStack getRecord() {
        return this.recordItem;
    }

    public void setRecord(@Nullable ItemStack recordItem) {
        this.recordItem = recordItem == null ? new ItemStack(Material.AIR) : recordItem;
        this.playing = !this.recordItem.getType().isAir();
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void stopPlaying() {
        this.playing = false;
    }

    public boolean eject() {
        if (!this.isPlaced()) {
            throw new IllegalStateException("Cannot eject from an unplaced jukebox");
        }
        if (this.getRecord().getType().isAir()) {
            return false;
        }
        this.getWorld().dropItem(this.getLocation().add(0.0, 1.0, 0.0), this.getRecord());
        this.setRecord(null);
        return true;
    }
}

