/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.AnimalsMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.AbstractHorseInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHorseMock
extends AnimalsMock
implements AbstractHorse {
    @Nullable
    private UUID owner;
    private int maxDomestication = 100;
    private int domestication;
    private double jumpStrength;
    private boolean tamed;
    private boolean isEating;
    private boolean isMouthOpen;
    private boolean rearing;

    protected AbstractHorseMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    @Deprecated
    public void setVariant(Horse.Variant variant) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public int getDomestication() {
        return this.domestication;
    }

    public void setDomestication(int value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)"Domestication cannot be less than zero");
        Preconditions.checkArgument((value <= this.getMaxDomestication() ? 1 : 0) != 0, (Object)"Domestication cannot be greater than the max domestication");
        this.domestication = value;
    }

    public int getMaxDomestication() {
        return this.maxDomestication;
    }

    public void setMaxDomestication(int value) {
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (Object)"Max domestication cannot be zero or less");
        this.maxDomestication = value;
    }

    public double getJumpStrength() {
        return this.jumpStrength;
    }

    public void setJumpStrength(double strength) {
        Preconditions.checkArgument((strength >= 0.0 ? 1 : 0) != 0, (Object)"Jump strength cannot be less than zero");
        this.jumpStrength = strength;
    }

    public boolean isTamed() {
        return this.tamed;
    }

    public void setTamed(boolean tamed) {
        this.tamed = tamed;
    }

    @Nullable
    public UUID getOwnerUniqueId() {
        return this.owner;
    }

    public AnimalTamer getOwner() {
        if (this.getOwnerUniqueId() == null) {
            return null;
        }
        return this.getServer().getOfflinePlayer(this.getOwnerUniqueId());
    }

    public void setOwner(@Nullable AnimalTamer owner) {
        if (owner != null) {
            this.setTamed(true);
            this.setOwnerUUID(owner.getUniqueId());
        } else {
            this.setTamed(false);
            this.setOwnerUUID(null);
        }
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.owner = uuid;
    }

    public boolean isEatingHaystack() {
        return this.isEating;
    }

    public void setEatingHaystack(boolean eatingHaystack) {
        this.isEating = eatingHaystack;
    }

    @NotNull
    public AbstractHorseInventory getInventory() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public boolean isEatingGrass() {
        return this.isEatingHaystack();
    }

    @Deprecated
    public void setEatingGrass(boolean eating) {
        this.setEatingHaystack(eating);
    }

    public boolean isRearing() {
        return this.rearing;
    }

    public void setRearing(boolean rearing) {
        this.rearing = rearing;
    }

    public boolean isEating() {
        return this.isMouthOpen;
    }

    public void setEating(boolean eating) {
        this.isMouthOpen = eating;
    }
}

