/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.CreatureMock;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Allay;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;

public class AllayMock
extends CreatureMock
implements Allay {
    @NotNull
    private final Inventory inventory = Bukkit.createInventory(null, (int)9);
    private Material currentItem;

    public AllayMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public void simulatePlayerInteract(@NotNull Material material) {
        Preconditions.checkNotNull((Object)material, (Object)"Material cannot be null");
        this.currentItem = material;
    }

    @Nullable
    public ItemStack simulateItemRetrieval() {
        ItemStack item = this.inventory.getContents()[0];
        this.inventory.clear();
        return item;
    }

    public void simulateItemPickup(@NotNull ItemStack item) {
        Preconditions.checkNotNull((Object)item, (Object)"ItemStack cannot be null");
        if (item.getType() != this.currentItem) {
            throw new IllegalArgumentException("Item is not the same type as the Allay is currently holding");
        }
        this.inventory.addItem(new ItemStack[]{item});
        if (Arrays.stream(this.inventory.getContents()).filter(Objects::nonNull).count() > 1L) {
            throw new IllegalStateException("Allay cannot hold more than 1 ItemStack");
        }
    }

    public void assertCurrentItem(@NotNull Material item) {
        this.assertCurrentItem(item, "Allay is not holding the correct item");
    }

    public void assertCurrentItem(@NotNull Material item, @Nullable String message) {
        if (item != this.currentItem) {
            Assertions.fail((String)message);
        }
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void assertInventoryContains(ItemStack item) {
        this.assertInventoryContains(item, "Inventory does not contain the given ItemStack");
    }

    public void assertInventoryContains(ItemStack item, String s) {
        if (!this.inventory.contains(item)) {
            Assertions.fail((String)s);
        }
    }

    public boolean canDuplicate() {
        throw new UnimplementedOperationException();
    }

    public void setCanDuplicate(boolean canDuplicate) {
        throw new UnimplementedOperationException();
    }

    public long getDuplicationCooldown() {
        throw new UnimplementedOperationException();
    }

    public void setDuplicationCooldown(long cooldown) {
        throw new UnimplementedOperationException();
    }

    public void resetDuplicationCooldown() {
        throw new UnimplementedOperationException();
    }

    public boolean isDancing() {
        throw new UnimplementedOperationException();
    }

    public void startDancing(@NotNull Location location) {
        throw new UnimplementedOperationException();
    }

    public void startDancing() {
        throw new UnimplementedOperationException();
    }

    public void stopDancing() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Allay duplicateAllay() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Location getJukebox() {
        throw new UnimplementedOperationException();
    }

    @Override
    public EntityType getType() {
        return EntityType.ALLAY;
    }
}

