/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.AnimalsMock;
import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Goat;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;

public class GoatMock
extends AnimalsMock
implements Goat {
    private boolean hasLeftHorn = true;
    private boolean hasRightHorn = true;
    private boolean isScreaming = false;
    private final List<LivingEntity> attackedMobs = new LinkedList<LivingEntity>();

    public GoatMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public boolean hasLeftHorn() {
        return this.hasLeftHorn;
    }

    public void setLeftHorn(boolean hasHorn) {
        this.hasLeftHorn = hasHorn;
    }

    public boolean hasRightHorn() {
        return this.hasRightHorn;
    }

    public void setRightHorn(boolean hasHorn) {
        this.hasRightHorn = hasHorn;
    }

    public boolean isScreaming() {
        return this.isScreaming;
    }

    public void setScreaming(boolean screaming) {
        this.isScreaming = screaming;
    }

    public void ram(@NotNull LivingEntity entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null");
        this.attackedMobs.add(entity);
    }

    public void assertEntityRammed(@NotNull LivingEntity entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null");
        if (!this.attackedMobs.contains(entity)) {
            Assertions.fail((String)("Expected Goat to have rammed " + entity.getName() + " but it did not!"));
        }
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.GOAT;
    }
}

