/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.AbstractHorseMock;
import be.seeseemelk.mockbukkit.inventory.HorseInventoryMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.HorseInventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public class HorseMock
extends AbstractHorseMock
implements Horse {
    private Horse.Color color;
    private Horse.Style style;
    private HorseInventory inventory = new HorseInventoryMock((InventoryHolder)this);

    public HorseMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
        this.color = Horse.Color.WHITE;
        this.style = Horse.Style.BLACK_DOTS;
        this.inventory = new HorseInventoryMock((InventoryHolder)this);
    }

    @NotNull
    public Horse.Color getColor() {
        Preconditions.checkState((this.color != null ? 1 : 0) != 0, (Object)"No color has been set");
        return this.color;
    }

    public void setColor(@NotNull Horse.Color color) {
        Preconditions.checkNotNull((Object)color, (Object)"Color cannot be null");
        this.color = color;
    }

    @NotNull
    public Horse.Style getStyle() {
        Preconditions.checkState((this.style != null ? 1 : 0) != 0, (Object)"No style has been set");
        return this.style;
    }

    public void setStyle(@NotNull Horse.Style style) {
        Preconditions.checkNotNull((Object)style, (Object)"Style cannot be null");
        this.style = style;
    }

    public boolean isCarryingChest() {
        return false;
    }

    public void setCarryingChest(boolean chest) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @NotNull
    public HorseInventory getInventory() {
        Preconditions.checkState((this.inventory != null ? 1 : 0) != 0, (Object)"No inventory has been set");
        return this.inventory;
    }

    @Deprecated
    @NotNull
    public Horse.Variant getVariant() {
        return Horse.Variant.HORSE;
    }

    @Override
    public EntityType getType() {
        return EntityType.HORSE;
    }
}

