/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.AsyncCatcher;
import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.attribute.AttributeInstanceMock;
import be.seeseemelk.mockbukkit.attribute.AttributesMock;
import be.seeseemelk.mockbukkit.entity.EntityMock;
import be.seeseemelk.mockbukkit.inventory.EntityEquipmentMock;
import be.seeseemelk.mockbukkit.potion.ActivePotionEffect;
import com.destroystokyo.paper.block.TargetBlockInfo;
import com.destroystokyo.paper.entity.TargetEntityInfo;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.util.TriState;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityCategory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Wither;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityToggleSwimEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Consumer;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LivingEntityMock
extends EntityMock
implements LivingEntity {
    protected double health;
    private int maxAirTicks = 300;
    private int remainingAirTicks = 300;
    protected boolean alive = true;
    private boolean gliding = false;
    private boolean jumping = false;
    protected Map<Attribute, AttributeInstanceMock> attributes;
    private final EntityEquipment equipment = new EntityEquipmentMock(this);
    private final Set<UUID> collidableExemptions = new HashSet<UUID>();
    private boolean collidable = true;
    private boolean ai = true;
    private boolean swimming;
    private double absorptionAmount;
    private int arrowCooldown;
    private int arrowsInBody;
    @Nullable
    private Player killer;
    private final Set<ActivePotionEffect> activeEffects = new HashSet<ActivePotionEffect>();
    private boolean invisible = false;
    private TriState frictionState = TriState.NOT_SET;
    private Entity leashHolder;

    protected LivingEntityMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
        this.attributes = new EnumMap<Attribute, AttributeInstanceMock>(Attribute.class);
        double maxHealth = AttributesMock.getDefaultValue(Attribute.GENERIC_MAX_HEALTH);
        this.attributes.put(Attribute.GENERIC_MAX_HEALTH, new AttributeInstanceMock(Attribute.GENERIC_MAX_HEALTH, maxHealth));
        double movementSpeed = AttributesMock.getDefaultValue(Attribute.GENERIC_MOVEMENT_SPEED);
        this.attributes.put(Attribute.GENERIC_MOVEMENT_SPEED, new AttributeInstanceMock(Attribute.GENERIC_MOVEMENT_SPEED, movementSpeed));
        this.resetMaxHealth();
        this.setHealth(maxHealth);
    }

    public double getHealth() {
        return this.health;
    }

    @Override
    public void remove() {
        this.health = 0.0;
        this.alive = false;
        super.remove();
    }

    @Override
    public boolean isDead() {
        return !this.alive || !super.isValid();
    }

    @Override
    public boolean isValid() {
        return !this.isDead();
    }

    public void setHealth(double health) {
        if (health > 0.0) {
            this.health = Math.min(health, this.getMaxHealth());
            return;
        }
        this.health = 0.0;
        EntityDeathEvent event = new EntityDeathEvent((LivingEntity)this, new ArrayList(), 0);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.alive = false;
    }

    public double getAbsorptionAmount() {
        return this.absorptionAmount;
    }

    public void setAbsorptionAmount(double amount) {
        Preconditions.checkArgument((amount >= 0.0 && Double.isFinite(amount) ? 1 : 0) != 0, (Object)"amount < 0 or non-finite");
        this.absorptionAmount = amount;
    }

    public double getMaxHealth() {
        return this.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
    }

    public void setMaxHealth(double health) {
        this.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(health);
        if (this.health > health) {
            this.health = health;
        }
    }

    public void resetMaxHealth() {
        this.setMaxHealth(AttributesMock.getDefaultValue(Attribute.GENERIC_MAX_HEALTH));
    }

    public void damage(double amount) {
        this.damage(amount, null);
    }

    public void damage(double amount, @Nullable Entity source) {
        if (this.isInvulnerable()) {
            if (source instanceof HumanEntity) {
                if (((Player)source).getGameMode() != GameMode.CREATIVE) {
                    return;
                }
            } else {
                return;
            }
        }
        EnumMap<EntityDamageEvent.DamageModifier, Double> modifiers = new EnumMap<EntityDamageEvent.DamageModifier, Double>(EntityDamageEvent.DamageModifier.class);
        modifiers.put(EntityDamageEvent.DamageModifier.BASE, 1.0);
        EnumMap<EntityDamageEvent.DamageModifier, Function> modifierFunctions = new EnumMap<EntityDamageEvent.DamageModifier, Function>(EntityDamageEvent.DamageModifier.class);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.BASE, damage -> damage);
        EntityDamageByEntityEvent event = source != null ? new EntityDamageByEntityEvent(source, (Entity)this, EntityDamageEvent.DamageCause.ENTITY_ATTACK, modifiers, modifierFunctions) : new EntityDamageEvent((Entity)this, EntityDamageEvent.DamageCause.CUSTOM, modifiers, modifierFunctions);
        event.setDamage(amount);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.setLastDamageCause((EntityDamageEvent)event);
            amount = event.getDamage();
            this.setHealth(this.health - amount);
        }
    }

    public AttributeInstance getAttribute(@NotNull Attribute attribute) {
        if (this.attributes.containsKey(attribute)) {
            return this.attributes.get(attribute);
        }
        throw new UnimplementedOperationException();
    }

    public void registerAttribute(@NotNull Attribute attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        this.attributes.put(attribute, new AttributeInstanceMock(attribute, AttributesMock.getDefaultValue(attribute)));
    }

    @NotNull
    public <T extends Projectile> T launchProjectile(@NotNull Class<? extends T> projectile) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public <T extends Projectile> T launchProjectile(@NotNull Class<? extends T> projectile, @Nullable Vector velocity) {
        Preconditions.checkNotNull(projectile, (Object)"Projectile cannot be null");
        T entity = this.launchProjectile(projectile);
        if (velocity != null) {
            entity.setVelocity(velocity);
        }
        return entity;
    }

    public double getEyeHeight() {
        throw new UnimplementedOperationException();
    }

    public double getEyeHeight(boolean ignorePose) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Location getEyeLocation() {
        return this.getLocation().add(0.0, this.getEyeHeight(), 0.0);
    }

    @NotNull
    public List<Block> getLineOfSight(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Block getTargetBlock(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Block getTargetBlock(int maxDistance, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull TargetBlockInfo.FluidMode fluidMode) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public BlockFace getTargetBlockFace(int maxDistance, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull TargetBlockInfo.FluidMode fluidMode) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public TargetBlockInfo getTargetBlockInfo(int maxDistance, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull TargetBlockInfo.FluidMode fluidMode) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Entity getTargetEntity(int maxDistance, boolean ignoreBlocks) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public TargetEntityInfo getTargetEntityInfo(int maxDistance, boolean ignoreBlocks) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public List<Block> getLastTwoTargetBlocks(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Block getTargetBlockExact(int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Block getTargetBlockExact(int maxDistance, @NotNull FluidCollisionMode fluidCollisionMode) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public RayTraceResult rayTraceBlocks(double maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public RayTraceResult rayTraceBlocks(double maxDistance, @NotNull FluidCollisionMode fluidCollisionMode) {
        throw new UnimplementedOperationException();
    }

    public int getRemainingAir() {
        return this.remainingAirTicks;
    }

    public void setRemainingAir(int ticks) {
        this.remainingAirTicks = ticks;
    }

    public int getMaximumAir() {
        return this.maxAirTicks;
    }

    public void setMaximumAir(int ticks) {
        this.maxAirTicks = ticks;
    }

    public int getMaximumNoDamageTicks() {
        throw new UnimplementedOperationException();
    }

    public void setMaximumNoDamageTicks(int ticks) {
        throw new UnimplementedOperationException();
    }

    public double getLastDamage() {
        throw new UnimplementedOperationException();
    }

    public void setLastDamage(double damage) {
        throw new UnimplementedOperationException();
    }

    public int getNoDamageTicks() {
        throw new UnimplementedOperationException();
    }

    public void setNoDamageTicks(int ticks) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Player getKiller() {
        return this.killer;
    }

    public void setKiller(@Nullable Player killer) {
        this.killer = killer;
    }

    public boolean addPotionEffect(@NotNull PotionEffect effect) {
        return this.addPotionEffect(effect, false);
    }

    @Deprecated
    public boolean addPotionEffect(@NotNull PotionEffect effect, boolean force) {
        AsyncCatcher.catchOp("effect add");
        Preconditions.checkNotNull((Object)effect, (Object)"PotionEffect cannot be null");
        this.activeEffects.add(new ActivePotionEffect(effect));
        return true;
    }

    public boolean addPotionEffects(@NotNull Collection<PotionEffect> effects) {
        Preconditions.checkNotNull(effects, (Object)"PotionEffect cannot be null");
        boolean successful = true;
        for (PotionEffect effect : effects) {
            if (this.addPotionEffect(effect)) continue;
            successful = false;
        }
        return successful;
    }

    public boolean hasPotionEffect(@NotNull PotionEffectType type) {
        return this.getPotionEffect(type) != null;
    }

    public PotionEffect getPotionEffect(@NotNull PotionEffectType type) {
        Preconditions.checkNotNull((Object)type, (Object)"Potion type cannot be null");
        for (PotionEffect effect : this.getActivePotionEffects()) {
            if (!effect.getType().equals((Object)type)) continue;
            return effect;
        }
        return null;
    }

    public void removePotionEffect(@NotNull PotionEffectType type) {
        Preconditions.checkNotNull((Object)type, (Object)"Potion type cannot be null");
        this.activeEffects.removeIf(effect -> effect.hasExpired() || effect.getPotionEffect().getType().equals((Object)type));
    }

    @NotNull
    public Collection<PotionEffect> getActivePotionEffects() {
        HashSet<PotionEffect> effects = new HashSet<PotionEffect>();
        Iterator<ActivePotionEffect> iterator = this.activeEffects.iterator();
        while (iterator.hasNext()) {
            ActivePotionEffect effect = iterator.next();
            if (effect.hasExpired()) {
                iterator.remove();
                continue;
            }
            effects.add(effect.getPotionEffect());
        }
        return effects;
    }

    public boolean hasLineOfSight(@NotNull Entity other) {
        throw new UnimplementedOperationException();
    }

    public boolean hasLineOfSight(@NotNull Location location) {
        throw new UnimplementedOperationException();
    }

    public boolean getRemoveWhenFarAway() {
        throw new UnimplementedOperationException();
    }

    public void setRemoveWhenFarAway(boolean remove) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public EntityEquipment getEquipment() {
        return this.equipment;
    }

    public void setCanPickupItems(boolean pickup) {
        throw new UnimplementedOperationException();
    }

    public boolean getCanPickupItems() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean teleport(@NotNull Location location, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerTeleportEvent.TeleportCause cause) {
        if (this.isDead()) {
            return false;
        }
        return super.teleport(location, cause);
    }

    public boolean isLeashed() {
        if (!(this.leashHolder instanceof Mob)) {
            return false;
        }
        return this.leashHolder != null;
    }

    @NotNull
    public Entity getLeashHolder() throws IllegalStateException {
        if (!this.isLeashed()) {
            throw new IllegalStateException("Entity is currently not leashed");
        }
        return this.leashHolder;
    }

    public boolean setLeashHolder(Entity holder) {
        if (this instanceof Wither || !(this instanceof Mob)) {
            return false;
        }
        if (holder != null && holder.isDead()) {
            return false;
        }
        this.leashHolder = holder;
        return true;
    }

    public boolean isGliding() {
        return this.gliding;
    }

    public void setGliding(boolean gliding) {
        this.gliding = gliding;
    }

    public boolean isSwimming() {
        return this.swimming;
    }

    public void setSwimming(boolean swimming) {
        if (this.isValid() && this.isSwimming() != swimming) {
            EntityToggleSwimEvent event = new EntityToggleSwimEvent((LivingEntity)this, swimming);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        this.swimming = swimming;
    }

    public boolean isRiptiding() {
        throw new UnimplementedOperationException();
    }

    public boolean isSleeping() {
        throw new UnimplementedOperationException();
    }

    public boolean isClimbing() {
        throw new UnimplementedOperationException();
    }

    public void setAI(boolean ai) {
        if (this instanceof Mob) {
            this.ai = ai;
        }
    }

    public boolean hasAI() {
        return this instanceof Mob && this.ai;
    }

    public void attack(@NotNull Entity target) {
        Preconditions.checkNotNull((Object)target, (Object)"Target cannot be null");
        if (!(this instanceof Player)) {
            throw new UnimplementedOperationException();
        }
        ((Player)this).attack(target);
    }

    public void swingMainHand() {
    }

    public void swingOffHand() {
    }

    public void setCollidable(boolean collidable) {
        this.collidable = collidable;
    }

    public boolean isCollidable() {
        return this.collidable;
    }

    @NotNull
    public Set<UUID> getCollidableExemptions() {
        return this.collidableExemptions;
    }

    @Nullable
    public <T> T getMemory(@NotNull MemoryKey<T> memoryKey) {
        throw new UnimplementedOperationException();
    }

    public <T> void setMemory(@NotNull MemoryKey<T> memoryKey, @Nullable T memoryValue) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Sound getHurtSound() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Sound getDeathSound() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Sound getFallDamageSound(int fallHeight) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Sound getFallDamageSoundSmall() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Sound getFallDamageSoundBig() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Sound getDrinkingSound(@NotNull ItemStack itemStack) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Sound getEatingSound(@NotNull ItemStack itemStack) {
        throw new UnimplementedOperationException();
    }

    public boolean canBreatheUnderwater() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public EntityCategory getCategory() {
        throw new UnimplementedOperationException();
    }

    public void setArrowsInBody(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"New arrow amount must be >= 0");
        this.arrowsInBody = count;
    }

    public int getBeeStingerCooldown() {
        throw new UnimplementedOperationException();
    }

    public void setBeeStingerCooldown(int ticks) {
        throw new UnimplementedOperationException();
    }

    public int getBeeStingersInBody() {
        throw new UnimplementedOperationException();
    }

    public void setBeeStingersInBody(int count) {
        throw new UnimplementedOperationException();
    }

    public int getArrowsInBody() {
        return this.arrowsInBody;
    }

    public void setArrowCooldown(int ticks) {
        this.arrowCooldown = ticks;
    }

    public int getArrowCooldown() {
        return this.arrowCooldown;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public int getArrowsStuck() {
        throw new UnimplementedOperationException();
    }

    public void setArrowsStuck(int arrows) {
        throw new UnimplementedOperationException();
    }

    public int getShieldBlockingDelay() {
        throw new UnimplementedOperationException();
    }

    public void setShieldBlockingDelay(int delay) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public ItemStack getActiveItem() {
        throw new UnimplementedOperationException();
    }

    public void clearActiveItem() {
        throw new UnimplementedOperationException();
    }

    public int getItemUseRemainingTime() {
        throw new UnimplementedOperationException();
    }

    public int getHandRaisedTime() {
        throw new UnimplementedOperationException();
    }

    public boolean isHandRaised() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public EquipmentSlot getHandRaised() {
        throw new UnimplementedOperationException();
    }

    public boolean isJumping() {
        return this.jumping;
    }

    public void setJumping(boolean jumping) {
        this.jumping = jumping;
    }

    public void playPickupItemAnimation(@NotNull Item item, int quantity) {
        throw new UnimplementedOperationException();
    }

    public float getHurtDirection() {
        throw new UnimplementedOperationException();
    }

    public void setHurtDirection(float hurtDirection) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public <T extends Projectile> T launchProjectile(@NotNull Class<? extends T> projectile, @Nullable Vector velocity, @Nullable Consumer<T> function) {
        throw new UnimplementedOperationException();
    }

    public void knockback(double strength, double directionX, double directionZ) {
        throw new UnimplementedOperationException();
    }

    public void broadcastSlotBreak(@NotNull EquipmentSlot slot) {
        throw new UnimplementedOperationException();
    }

    public void broadcastSlotBreak(@NotNull EquipmentSlot slot, @NotNull Collection<Player> players) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemStack damageItemStack(@NotNull ItemStack stack, int amount) {
        throw new UnimplementedOperationException();
    }

    public void damageItemStack(@NotNull EquipmentSlot slot, int amount) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public TriState getFrictionState() {
        return this.frictionState;
    }

    public void setFrictionState(@NotNull TriState state) {
        Preconditions.checkNotNull((Object)state, (Object)"State cannot be null");
        this.frictionState = state;
    }

    @Nullable
    public BlockFace getTargetBlockFace(int maxDistance, @NotNull FluidCollisionMode fluidMode) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public RayTraceResult rayTraceEntities(int maxDistance, boolean ignoreBlocks) {
        throw new UnimplementedOperationException();
    }

    public void setArrowsInBody(int count, boolean fireEvent) {
        throw new UnimplementedOperationException();
    }

    public float getBodyYaw() {
        throw new UnimplementedOperationException();
    }

    public void setBodyYaw(float bodyYaw) {
        throw new UnimplementedOperationException();
    }
}

