/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.AbstractSkeletonMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Skeleton;
import org.jetbrains.annotations.NotNull;

public class SkeletonMock
extends AbstractSkeletonMock
implements Skeleton {
    private boolean isConverting = false;
    private int conversionTime = 0;
    private int inPowderedSnow = 0;

    public SkeletonMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public boolean isConverting() {
        return this.isConverting;
    }

    public void setConverting(boolean state) {
        this.isConverting = state;
    }

    public int getConversionTime() {
        Preconditions.checkState((boolean)this.isConverting(), (Object)"Entity is not converting");
        return this.conversionTime;
    }

    public void setConversionTime(int time) {
        if (time < 0) {
            this.conversionTime = -1;
            return;
        }
        this.conversionTime = time;
    }

    public int inPowderedSnowTime() {
        return this.inPowderedSnow;
    }

    public void setInPowderedSnowTime(int time) {
        Preconditions.checkArgument((time > 0 ? 1 : 0) != 0, (Object)"Time cannot be smaller than 1");
        this.inPowderedSnow = time;
    }

    @Deprecated
    @NotNull
    public Skeleton.SkeletonType getSkeletonType() {
        return Skeleton.SkeletonType.NORMAL;
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.SKELETON;
    }
}

