/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory;

import be.seeseemelk.mockbukkit.inventory.InventoryMock;
import com.google.common.base.Preconditions;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.Nullable;

public class AnvilInventoryMock
extends InventoryMock
implements AnvilInventory {
    @Nullable
    private String renameText;
    private int repairCostAmount = 0;
    private int repairCost = 0;
    private int maxRepairCost = 40;

    public AnvilInventoryMock(@Nullable InventoryHolder holder) {
        super(holder, InventoryType.ANVIL);
    }

    @Nullable
    public String getRenameText() {
        return this.renameText;
    }

    public int getRepairCostAmount() {
        return this.repairCostAmount;
    }

    public void setRepairCostAmount(int amount) {
        Preconditions.checkArgument((amount >= 0 ? 1 : 0) != 0, (Object)"Amount cannot be lower than 0");
        this.repairCostAmount = amount;
    }

    public int getRepairCost() {
        return this.repairCost;
    }

    public void setRepairCost(int levels) {
        Preconditions.checkArgument((levels >= 0 ? 1 : 0) != 0, (Object)"Levels cannot be lower than 0");
        this.repairCost = levels;
    }

    public int getMaximumRepairCost() {
        return this.maxRepairCost;
    }

    public void setMaximumRepairCost(int levels) {
        Preconditions.checkArgument((levels >= 0 ? 1 : 0) != 0, (Object)"Levels cannot be lower than 0");
        this.maxRepairCost = levels;
    }

    public void setRenameText(@Nullable String text) {
        this.renameText = text;
    }
}

