/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;

public class InventoryMock
implements Inventory {
    private static final int MAX_STACK_SIZE = 64;
    private final ItemStack @NotNull [] items;
    @Nullable
    private final InventoryHolder holder;
    @NotNull
    private final InventoryType type;
    private int maxStackSize = 64;
    @NotNull
    private final List<HumanEntity> viewers = new ArrayList<HumanEntity>();

    public InventoryMock(@Nullable InventoryHolder holder, int size, @NotNull InventoryType type) {
        Preconditions.checkArgument((2 == size || 9 <= size && size <= 54 && size % 9 == 0 ? 1 : 0) != 0, (Object)("Size for custom inventory must be two or a multiple of 9 between 9 and 54 slots (got " + size + ")"));
        Preconditions.checkNotNull((Object)type, (Object)"The InventoryType must not be null!");
        this.holder = holder;
        this.type = type;
        this.items = new ItemStack[size];
    }

    public InventoryMock(@Nullable InventoryHolder holder, @NotNull InventoryType type) {
        Preconditions.checkNotNull((Object)type, (Object)"The InventoryType must not be null!");
        this.holder = holder;
        this.type = type;
        this.items = new ItemStack[type.getDefaultSize()];
    }

    public void assertTrueForAll(@NotNull Predicate<ItemStack> condition) {
        for (ItemStack item : this.items) {
            Assertions.assertTrue((boolean)condition.test(item));
        }
    }

    public void assertTrueForNonNulls(@NotNull Predicate<ItemStack> condition) {
        this.assertTrueForAll(itemstack -> itemstack == null || condition.test((ItemStack)itemstack));
    }

    public void assertTrueForSome(@NotNull Predicate<ItemStack> condition) {
        for (ItemStack item : this.items) {
            if (item == null || !condition.test(item)) continue;
            return;
        }
        Assertions.fail((String)"Condition was not met for any items");
    }

    public void assertContainsAny(@NotNull ItemStack item) {
        this.assertTrueForSome(arg_0 -> ((ItemStack)item).isSimilar(arg_0));
    }

    public void assertContainsAtLeast(@NotNull ItemStack item, int amount) {
        int n = this.getNumberOfItems(item);
        String message = String.format("Inventory contains only <%d> but expected at least <%d>", n, amount);
        Assertions.assertTrue((n >= amount ? 1 : 0) != 0, (String)message);
    }

    public int getNumberOfItems(@NotNull ItemStack item) {
        int amount = 0;
        for (ItemStack itemstack : this.items) {
            if (itemstack == null || !item.isSimilar(itemstack)) continue;
            amount += itemstack.getAmount();
        }
        return amount;
    }

    public void addViewer(@NotNull HumanEntity viewer) {
        Preconditions.checkNotNull((Object)viewer, (Object)"The viewer must not be null!");
        this.viewers.add(viewer);
    }

    public void addViewers(HumanEntity ... viewers) {
        this.addViewers(Arrays.asList(viewers));
    }

    public void addViewers(@NotNull List<HumanEntity> viewers) {
        for (HumanEntity viewer : viewers) {
            Preconditions.checkNotNull((Object)viewer, (Object)"The viewer must not be null!");
            this.addViewer(viewer);
        }
    }

    public void removeViewer(@NotNull HumanEntity viewer) {
        Preconditions.checkNotNull((Object)viewer, (Object)"The viewer must not be null!");
        this.viewers.remove(viewer);
    }

    public int getSize() {
        return this.items.length;
    }

    public ItemStack getItem(int index) {
        return this.items[index];
    }

    public void setItem(int index, @Nullable ItemStack item) {
        this.items[index] = item == null ? null : item.clone();
    }

    @Nullable
    public ItemStack addItem(@NotNull ItemStack item) {
        int itemMaxStackSize = Math.min(item.getMaxStackSize(), this.maxStackSize);
        item = item.clone();
        for (int i = 0; i < this.items.length; ++i) {
            ItemStack oItem = this.items[i];
            if (oItem == null) {
                int toAdd = Math.min(item.getAmount(), itemMaxStackSize);
                this.items[i] = item.clone();
                this.items[i].setAmount(toAdd);
                item.setAmount(item.getAmount() - toAdd);
            } else {
                int oItemMaxStackSize = Math.min(oItem.getMaxStackSize(), this.maxStackSize);
                if (item.isSimilar(oItem) && oItem.getAmount() < oItemMaxStackSize) {
                    int toAdd = Math.min(item.getAmount(), oItemMaxStackSize - oItem.getAmount());
                    oItem.setAmount(oItem.getAmount() + toAdd);
                    item.setAmount(item.getAmount() - toAdd);
                }
            }
            if (item.getAmount() != 0) continue;
            return null;
        }
        return item;
    }

    @NotNull
    public HashMap<Integer, ItemStack> addItem(ItemStack ... items) throws IllegalArgumentException {
        HashMap<Integer, ItemStack> notSaved = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            ItemStack left = this.addItem(item);
            if (left == null) continue;
            notSaved.put(i, left);
        }
        return notSaved;
    }

    public ItemStack @NotNull [] getContents() {
        return this.items;
    }

    public void setContents(ItemStack @NotNull [] items) {
        for (int i = 0; i < this.getSize(); ++i) {
            this.items[i] = i < items.length && items[i] != null ? items[i].clone() : null;
        }
    }

    @Nullable
    public InventoryHolder getHolder() {
        return this.holder;
    }

    @Nullable
    public InventoryHolder getHolder(boolean useSnapshot) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ListIterator<ItemStack> iterator() {
        List list = Arrays.asList(this.items).stream().filter(Objects::nonNull).collect(Collectors.toList());
        return list.listIterator();
    }

    @NotNull
    public InventoryType getType() {
        return this.type;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public void setMaxStackSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Max stack size cannot be lower than 1");
        }
        if (size > 127) {
            throw new IllegalArgumentException("Stack sizes larger than 127 may get clipped");
        }
        this.maxStackSize = size;
    }

    @NotNull
    public HashMap<Integer, ItemStack> removeItem(ItemStack ... items) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)items, (Object)"Items cannot be null");
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        block0: for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            int toDelete = item.getAmount();
            while (toDelete > 0) {
                int first = this.first(item, false);
                if (first == -1) {
                    item.setAmount(toDelete);
                    leftover.put(i, item);
                    continue block0;
                }
                ItemStack itemStack = this.getItem(first);
                int amount = itemStack.getAmount();
                if (amount <= toDelete) {
                    toDelete -= amount;
                    this.clear(first);
                    continue;
                }
                itemStack.setAmount(amount - toDelete);
                this.setItem(first, itemStack);
                toDelete = 0;
            }
        }
        return leftover;
    }

    @NotNull
    public HashMap<Integer, ItemStack> removeItemAnySlot(ItemStack ... items) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public ItemStack @NotNull [] getStorageContents() {
        return this.getContents();
    }

    public void setStorageContents(ItemStack @NotNull [] items) throws IllegalArgumentException {
        this.setContents(items);
    }

    public boolean contains(@Nullable Material material) throws IllegalArgumentException {
        if (material == null) {
            throw new IllegalArgumentException("Material cannot be null.");
        }
        for (ItemStack itemStack : this.getContents()) {
            if (itemStack == null || itemStack.getType() != material) continue;
            return true;
        }
        return false;
    }

    public boolean contains(ItemStack item) {
        return this.contains(Objects.requireNonNull(item).getType());
    }

    public boolean contains(@Nullable Material material, int amount) throws IllegalArgumentException {
        if (material == null) {
            throw new IllegalArgumentException("Material cannot be null.");
        }
        return amount < 1 || this.getNumberOfItems(new ItemStack(material)) == amount;
    }

    public boolean contains(@NotNull ItemStack item, int amount) {
        return this.getNumberOfItems(item) == amount;
    }

    public boolean containsAtLeast(@NotNull ItemStack item, int amount) {
        return this.getNumberOfItems(item) >= amount;
    }

    @NotNull
    public HashMap<Integer, ? extends ItemStack> all(@NotNull Material material) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)material, (Object)"Material cannot be null");
        HashMap<Integer, ItemStack> slots = new HashMap<Integer, ItemStack>();
        ItemStack[] items = this.getStorageContents();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].getType() != material) continue;
            slots.put(i, items[i]);
        }
        return slots;
    }

    @NotNull
    public HashMap<Integer, ? extends ItemStack> all(@Nullable ItemStack item) {
        HashMap<Integer, ItemStack> slots = new HashMap<Integer, ItemStack>();
        if (item != null) {
            ItemStack[] items = this.getStorageContents();
            for (int i = 0; i < items.length; ++i) {
                if (!item.equals((Object)items[i])) continue;
                slots.put(i, items[i]);
            }
        }
        return slots;
    }

    public int first(@NotNull Material material) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)material, (Object)"Material cannot be null");
        ItemStack[] items = this.getStorageContents();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].getType() != material) continue;
            return i;
        }
        return -1;
    }

    public int first(@NotNull ItemStack item) {
        if (item == null) {
            return -1;
        }
        ItemStack[] items = this.getStorageContents();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || !item.equals((Object)items[i])) continue;
            return i;
        }
        return -1;
    }

    private int first(@NotNull ItemStack item, boolean withAmount) {
        Preconditions.checkNotNull((Object)item, (Object)"ItemStack cannot be null");
        ItemStack[] inventory = this.getStorageContents();
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] == null || !(withAmount ? item.equals((Object)inventory[i]) : item.isSimilar(inventory[i]))) continue;
            return i;
        }
        return -1;
    }

    public int firstEmpty() {
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.items[i] != null && this.items[i].getType() != Material.AIR) continue;
            return i;
        }
        return -1;
    }

    public void remove(@NotNull Material material) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)material, (Object)"Material cannot be null");
        ItemStack[] items = this.getStorageContents();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].getType() != material) continue;
            this.clear(i);
        }
    }

    public void remove(@NotNull ItemStack item) {
        ItemStack[] items = this.getStorageContents();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || !items[i].equals((Object)item)) continue;
            this.clear(i);
        }
    }

    public void clear(int index) {
        this.items[index] = null;
    }

    public void clear() {
        Arrays.fill(this.items, null);
    }

    public int close() {
        int count = this.viewers.size();
        Lists.newArrayList(this.viewers).forEach(HumanEntity::closeInventory);
        return count;
    }

    @NotNull
    public List<HumanEntity> getViewers() {
        return this.viewers;
    }

    @NotNull
    public ListIterator<ItemStack> iterator(int index) {
        throw new UnimplementedOperationException();
    }

    public Location getLocation() {
        throw new UnimplementedOperationException();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.items[i] == null || this.items[i].getType() == Material.AIR) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Inventory getSnapshot() {
        InventoryMock inventory = new InventoryMock(this.holder, this.getSize(), this.type);
        inventory.setContents(this.getContents());
        return inventory;
    }
}

