/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.inventory.meta.ArmorStandMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.AxolotlBucketMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.BannerMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.BookMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.BundleMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.CompassMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.CrossbowMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.EnchantedBookMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.FireworkEffectMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.FireworkMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.KnowledgeBookMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.LeatherArmorMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.MapMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.PotionMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.SkullMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.SpawnEggMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.SuspiciousStewMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.TropicalFishBucketMetaMock;
import com.destroystokyo.paper.MaterialTags;
import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.Random;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class ItemFactoryMock
implements ItemFactory {
    private final Color defaultLeatherColor = Color.fromRGB((int)10511680);

    @NotNull
    private Class<? extends ItemMeta> getItemMetaClass(@NotNull Material material) {
        if (Tag.ITEMS_BANNERS.isTagged((Keyed)material)) {
            return BannerMetaMock.class;
        }
        if (MaterialTags.SPAWN_EGGS.isTagged(material)) {
            return SpawnEggMetaMock.class;
        }
        return switch (material) {
            case Material.ARMOR_STAND -> ArmorStandMetaMock.class;
            case Material.WRITABLE_BOOK, Material.WRITTEN_BOOK -> BookMetaMock.class;
            case Material.ENCHANTED_BOOK -> EnchantedBookMetaMock.class;
            case Material.KNOWLEDGE_BOOK -> KnowledgeBookMetaMock.class;
            case Material.LEATHER_BOOTS, Material.LEATHER_CHESTPLATE, Material.LEATHER_HELMET, Material.LEATHER_LEGGINGS -> LeatherArmorMetaMock.class;
            case Material.FILLED_MAP -> MapMetaMock.class;
            case Material.FIREWORK_STAR -> FireworkEffectMetaMock.class;
            case Material.FIREWORK_ROCKET -> FireworkMetaMock.class;
            case Material.POTION, Material.LINGERING_POTION, Material.SPLASH_POTION -> PotionMetaMock.class;
            case Material.PLAYER_HEAD -> SkullMetaMock.class;
            case Material.SUSPICIOUS_STEW -> SuspiciousStewMetaMock.class;
            case Material.AXOLOTL_BUCKET -> AxolotlBucketMetaMock.class;
            case Material.BUNDLE -> BundleMetaMock.class;
            case Material.COMPASS -> CompassMetaMock.class;
            case Material.CROSSBOW -> CrossbowMetaMock.class;
            case Material.TROPICAL_FISH_BUCKET -> TropicalFishBucketMetaMock.class;
            default -> ItemMetaMock.class;
        };
    }

    @NotNull
    public ItemMeta getItemMeta(@NotNull Material material) {
        Preconditions.checkNotNull((Object)material, (Object)"Material cannot be null");
        Class<? extends ItemMeta> clazz = null;
        try {
            clazz = this.getItemMetaClass(material);
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new UnsupportedOperationException("Can't instantiate class '" + clazz + "'");
        }
    }

    public boolean isApplicable(ItemMeta meta, @NotNull ItemStack stack) {
        return this.isApplicable(meta, stack.getType());
    }

    public boolean isApplicable(ItemMeta meta, @NotNull Material material) {
        Class<? extends ItemMeta> target = this.getItemMetaClass(material);
        return target.isInstance(meta);
    }

    public boolean equals(ItemMeta meta1, ItemMeta meta2) {
        return Objects.equals(meta1, meta2);
    }

    public ItemMeta asMetaFor(@NotNull ItemMeta meta, @NotNull ItemStack stack) {
        return this.asMetaFor(meta, stack.getType());
    }

    public ItemMeta asMetaFor(@NotNull ItemMeta meta, @NotNull Material material) {
        Class<? extends ItemMeta> target = this.getItemMetaClass(material);
        try {
            for (Constructor<?> constructor : target.getDeclaredConstructors()) {
                if (constructor.getParameterCount() != 1 || !constructor.getParameterTypes()[0].isAssignableFrom(meta.getClass())) continue;
                return (ItemMeta)constructor.newInstance(meta);
            }
            throw new NoSuchMethodException("Cannot find an ItemMeta constructor for the class \"" + meta.getClass().getName() + "\"");
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public Color getDefaultLeatherColor() {
        return this.defaultLeatherColor;
    }

    @NotNull
    public ItemStack createItemStack(@NotNull String input) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public Material updateMaterial(ItemMeta meta, @NotNull Material material) {
        return material;
    }

    @NotNull
    public ItemStack enchantWithLevels(@NotNull ItemStack itemStack, @Range(from=1L, to=30L) int levels, boolean allowTreasure, @NotNull Random random) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public HoverEvent<HoverEvent.ShowItem> asHoverEvent(@NotNull ItemStack item, @NotNull UnaryOperator<HoverEvent.ShowItem> op) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Component displayName(@NotNull ItemStack itemStack) {
        return itemStack.displayName();
    }

    @Deprecated
    @Nullable
    public String getI18NDisplayName(@Nullable ItemStack item) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemStack ensureServerConversions(@NotNull ItemStack item) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public Content hoverContentOf(@NotNull ItemStack itemStack) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public Content hoverContentOf(@NotNull Entity entity) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public Content hoverContentOf(@NotNull Entity entity, @Nullable String customName) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public Content hoverContentOf(@NotNull Entity entity, @Nullable BaseComponent customName) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public Content hoverContentOf(@NotNull Entity entity, @NotNull BaseComponent[] customName) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public ItemStack getSpawnEgg(@Nullable EntityType type) {
        throw new UnimplementedOperationException();
    }
}

