/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.scoreboard;

import be.seeseemelk.mockbukkit.entity.EntityMock;
import be.seeseemelk.mockbukkit.scoreboard.ScoreMock;
import be.seeseemelk.mockbukkit.scoreboard.ScoreboardMock;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectiveMock
implements Objective {
    @Nullable
    private ScoreboardMock scoreboard;
    @NotNull
    private final String name;
    @NotNull
    private final Criteria criteria;
    private final Map<String, ScoreMock> scores = new HashMap<String, ScoreMock>();
    @NotNull
    private Component displayName;
    @Nullable
    private DisplaySlot displaySlot;
    private RenderType renderType;

    public ObjectiveMock(@NotNull ScoreboardMock scoreboard, @NotNull String name, @Nullable Component displayName, @NotNull Criteria criteria, @NotNull RenderType renderType) {
        Preconditions.checkNotNull((Object)scoreboard, (Object)"When registering an Objective to the Scoreboard the scoreboard cannot be null.");
        Preconditions.checkNotNull((Object)name, (Object)"The name cannot be null");
        Preconditions.checkNotNull((Object)criteria, (Object)"The criteria cannot be null");
        this.scoreboard = scoreboard;
        this.name = name;
        this.displayName = displayName == null ? Component.empty() : displayName;
        this.criteria = criteria;
        this.renderType = renderType;
    }

    private void validate() throws IllegalStateException {
        if (!this.isRegistered()) {
            throw new IllegalStateException("This objective is no longer registered.");
        }
    }

    @NotNull
    public String getName() throws IllegalStateException {
        this.validate();
        return this.name;
    }

    @NotNull
    public Component displayName() throws IllegalStateException {
        return this.displayName;
    }

    public void displayName(@Nullable Component displayName) throws IllegalStateException, IllegalArgumentException {
        this.displayName = displayName;
    }

    @Deprecated
    @NotNull
    public String getDisplayName() throws IllegalStateException {
        this.validate();
        return LegacyComponentSerializer.legacySection().serialize(this.displayName);
    }

    @Deprecated
    public void setDisplayName(@NotNull String displayName) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)displayName, (Object)"The display name cannot be null");
        Preconditions.checkArgument((displayName.length() <= 128 ? 1 : 0) != 0, (Object)"The display name cannot be longer than 128 characters");
        this.validate();
        this.displayName = LegacyComponentSerializer.legacySection().deserialize(displayName);
    }

    @NotNull
    public String getCriteria() throws IllegalStateException {
        this.validate();
        return this.criteria.getName();
    }

    @NotNull
    public Criteria getTrackedCriteria() throws IllegalStateException {
        this.validate();
        return this.criteria;
    }

    public ScoreboardMock getScoreboard() {
        return this.scoreboard;
    }

    public void unregister() throws IllegalStateException {
        this.validate();
        this.scoreboard.unregister(this);
        this.scoreboard = null;
    }

    public boolean isRegistered() {
        return this.scoreboard != null && this.scoreboard.getObjectives().contains(this);
    }

    public void setDisplaySlot(@Nullable DisplaySlot slot) throws IllegalStateException {
        this.validate();
        this.displaySlot = slot;
        this.scoreboard.setDisplaySlot(this, slot);
    }

    public DisplaySlot getDisplaySlot() throws IllegalStateException {
        this.validate();
        return this.displaySlot;
    }

    public void setRenderType(@NotNull RenderType renderType) throws IllegalStateException {
        this.validate();
        this.renderType = renderType;
    }

    @NotNull
    public RenderType getRenderType() throws IllegalStateException {
        this.validate();
        return this.renderType;
    }

    @Deprecated
    @NotNull
    public ScoreMock getScore(@NotNull OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkNotNull((Object)player, (Object)"The player cannot be null");
        this.validate();
        return this.getScore(player.getName());
    }

    @NotNull
    public ScoreMock getScore(@NotNull String entry) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkNotNull((Object)entry, (Object)"The entry cannot be null");
        Preconditions.checkArgument((entry.length() <= 40 ? 1 : 0) != 0, (Object)"Objective entries cannot be longer than 40 characters");
        this.validate();
        ScoreMock score = this.scores.get(entry);
        if (score != null) {
            return score;
        }
        score = new ScoreMock(this, entry);
        this.scores.put(entry, score);
        return score;
    }

    @NotNull
    public Score getScoreFor(@NotNull Entity entity) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null");
        return this.getScore(((EntityMock)entity).getScoreboardEntry());
    }

    public boolean isModifiable() throws IllegalStateException {
        return !this.getTrackedCriteria().isReadOnly();
    }
}

