/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.jetbrains.annotations.NotNull;

public class MockBanList
implements BanList {
    private final Map<String, BanEntry> bans = new HashMap<String, BanEntry>();

    public BanEntry getBanEntry(String target) {
        return this.bans.getOrDefault(target, null);
    }

    public BanEntry addBan(String target, String reason, Date expires, String source) {
        MockBanEntry entry = new MockBanEntry(target, expires, reason, source);
        this.bans.put(target, entry);
        return entry;
    }

    @NotNull
    public Set<BanEntry> getBanEntries() {
        return new HashSet<BanEntry>(this.bans.values());
    }

    public boolean isBanned(String target) {
        return this.bans.containsKey(target);
    }

    public void pardon(String target) {
        this.bans.remove(target);
    }

    public static final class MockBanEntry
    implements BanEntry {
        private final String target;
        private String source;
        private String reason;
        private Date created;
        private Date expires;

        public MockBanEntry(String target, Date expires, String reason, String source) {
            this.target = target;
            this.expires = expires;
            this.reason = reason;
            this.source = source;
            this.created = new Date();
        }

        @NotNull
        public String getTarget() {
            return this.target;
        }

        @NotNull
        public Date getCreated() {
            return this.created;
        }

        public void setCreated(Date created) {
            this.created = created;
        }

        @NotNull
        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public Date getExpiration() {
            return this.expires;
        }

        public void setExpiration(Date expiration) {
            this.expires = expiration;
        }

        public String getReason() {
            return this.reason;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        public void save() {
            throw new UnimplementedOperationException();
        }

        public int hashCode() {
            return this.created.hashCode() + this.target.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof BanEntry) {
                BanEntry banEntry = (BanEntry)obj;
                return this.target.equals(banEntry.getTarget()) && this.expires.equals(banEntry.getExpiration()) && this.reason.equals(banEntry.getReason()) && this.source.equals(banEntry.getSource()) && this.created.equals(banEntry.getCreated());
            }
            return false;
        }
    }
}

