/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.LivingEntityMock;
import com.google.common.base.Preconditions;
import io.papermc.paper.math.Rotations;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArmorStandMock
extends LivingEntityMock
implements ArmorStand {
    private boolean hasArms = false;
    private boolean isSmall = false;
    private boolean isMarker = false;
    private boolean hasBasePlate = true;
    private boolean isVisible = true;
    @NotNull
    private EulerAngle headPose = EulerAngle.ZERO;
    @NotNull
    private EulerAngle bodyPose = EulerAngle.ZERO;
    @NotNull
    private EulerAngle leftArmPose = new EulerAngle(Math.toRadians(-10.0), 0.0, Math.toRadians(-10.0));
    @NotNull
    private EulerAngle rightArmPose = new EulerAngle(Math.toRadians(-15.0), 0.0, Math.toRadians(10.0));
    @NotNull
    private EulerAngle leftLegPose = new EulerAngle(Math.toRadians(-1.0), 0.0, Math.toRadians(-1.0));
    @NotNull
    private EulerAngle rightLegPose = new EulerAngle(Math.toRadians(1.0), 0.0, Math.toRadians(1.0));
    private final Set<EquipmentSlot> disabledSlots = EnumSet.noneOf(EquipmentSlot.class);

    public ArmorStandMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.ARMOR_STAND;
    }

    @Deprecated
    @NotNull
    public ItemStack getBoots() {
        return this.getEquipment().getBoots();
    }

    @Deprecated
    public void setBoots(@Nullable ItemStack item) {
        this.getEquipment().setBoots(item);
    }

    @Deprecated
    @NotNull
    public ItemStack getLeggings() {
        return this.getEquipment().getLeggings();
    }

    @Deprecated
    public void setLeggings(@Nullable ItemStack item) {
        this.getEquipment().setLeggings(item);
    }

    @Deprecated
    @NotNull
    public ItemStack getChestplate() {
        return this.getEquipment().getChestplate();
    }

    @Deprecated
    public void setChestplate(@Nullable ItemStack item) {
        this.getEquipment().setChestplate(item);
    }

    @Deprecated
    @NotNull
    public ItemStack getHelmet() {
        return this.getEquipment().getHelmet();
    }

    @Deprecated
    public void setHelmet(@Nullable ItemStack item) {
        this.getEquipment().setHelmet(item);
    }

    @Deprecated
    @NotNull
    public ItemStack getItemInHand() {
        return this.getEquipment().getItemInMainHand();
    }

    @Deprecated
    public void setItemInHand(@Nullable ItemStack item) {
        this.getEquipment().setItemInMainHand(item);
    }

    @NotNull
    public EulerAngle getBodyPose() {
        return this.bodyPose;
    }

    public void setBodyPose(@NotNull EulerAngle pose) {
        Preconditions.checkNotNull((Object)pose, (Object)"Pose cannot be null");
        this.bodyPose = pose;
    }

    @NotNull
    public EulerAngle getLeftArmPose() {
        return this.leftArmPose;
    }

    public void setLeftArmPose(@NotNull EulerAngle pose) {
        Preconditions.checkNotNull((Object)pose, (Object)"Pose cannot be null");
        this.leftArmPose = pose;
    }

    @NotNull
    public EulerAngle getRightArmPose() {
        return this.rightArmPose;
    }

    public void setRightArmPose(@NotNull EulerAngle pose) {
        Preconditions.checkNotNull((Object)pose, (Object)"Pose cannot be null");
        this.rightArmPose = pose;
    }

    @NotNull
    public EulerAngle getLeftLegPose() {
        return this.leftLegPose;
    }

    public void setLeftLegPose(@NotNull EulerAngle pose) {
        Preconditions.checkNotNull((Object)pose, (Object)"Pose cannot be null");
        this.leftLegPose = pose;
    }

    @NotNull
    public EulerAngle getRightLegPose() {
        return this.rightLegPose;
    }

    public void setRightLegPose(@NotNull EulerAngle pose) {
        Preconditions.checkNotNull((Object)pose, (Object)"Pose cannot be null");
        this.rightLegPose = pose;
    }

    @NotNull
    public EulerAngle getHeadPose() {
        return this.headPose;
    }

    public void setHeadPose(@NotNull EulerAngle pose) {
        Preconditions.checkNotNull((Object)pose, (Object)"Pose cannot be null");
        this.headPose = pose;
    }

    public boolean hasBasePlate() {
        return this.hasBasePlate;
    }

    public void setBasePlate(boolean basePlate) {
        this.hasBasePlate = basePlate;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean hasArms() {
        return this.hasArms;
    }

    public void setArms(boolean arms) {
        this.hasArms = arms;
    }

    public boolean isSmall() {
        return this.isSmall;
    }

    public void setSmall(boolean small) {
        this.isSmall = small;
    }

    public boolean isMarker() {
        return this.isMarker;
    }

    public void setMarker(boolean marker) {
        this.isMarker = marker;
    }

    public void addEquipmentLock(@NotNull EquipmentSlot slot, @NotNull ArmorStand.LockType lockType) {
        throw new UnimplementedOperationException();
    }

    public void removeEquipmentLock(@NotNull EquipmentSlot slot, @NotNull ArmorStand.LockType lockType) {
        throw new UnimplementedOperationException();
    }

    public boolean hasEquipmentLock(@NotNull EquipmentSlot slot, @NotNull ArmorStand.LockType lockType) {
        throw new UnimplementedOperationException();
    }

    public boolean canMove() {
        throw new UnimplementedOperationException();
    }

    public void setCanMove(boolean move) {
        throw new UnimplementedOperationException();
    }

    public boolean canTick() {
        throw new UnimplementedOperationException();
    }

    public void setCanTick(boolean tick) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemStack getItem(@NotNull EquipmentSlot slot) {
        Preconditions.checkNotNull((Object)slot, (Object)"Slot cannot be null");
        return switch (slot) {
            default -> throw new IncompatibleClassChangeError();
            case EquipmentSlot.HAND -> this.getEquipment().getItemInMainHand();
            case EquipmentSlot.OFF_HAND -> this.getEquipment().getItemInOffHand();
            case EquipmentSlot.FEET -> this.getBoots();
            case EquipmentSlot.LEGS -> this.getLeggings();
            case EquipmentSlot.CHEST -> this.getChestplate();
            case EquipmentSlot.HEAD -> this.getHelmet();
        };
    }

    public void setItem(@NotNull EquipmentSlot slot, @Nullable ItemStack item) {
        Preconditions.checkNotNull((Object)slot, (Object)"Slot cannot be null");
        if (item == null) {
            item = new ItemStack(Material.AIR);
        }
        switch (slot) {
            case HAND: {
                this.getEquipment().setItemInMainHand(item);
                break;
            }
            case OFF_HAND: {
                this.getEquipment().setItemInOffHand(item);
                break;
            }
            case FEET: {
                this.setBoots(item);
                break;
            }
            case LEGS: {
                this.setLeggings(item);
                break;
            }
            case CHEST: {
                this.setChestplate(item);
                break;
            }
            case HEAD: {
                this.setHelmet(item);
            }
        }
    }

    @NotNull
    public Set<EquipmentSlot> getDisabledSlots() {
        return EnumSet.copyOf(this.disabledSlots);
    }

    public void setDisabledSlots(EquipmentSlot ... slots) {
        Preconditions.checkNotNull((Object)slots, (Object)"Slots cannot be null");
        this.disabledSlots.clear();
        Collections.addAll(this.disabledSlots, slots);
    }

    public void addDisabledSlots(EquipmentSlot ... slots) {
        Preconditions.checkNotNull((Object)slots, (Object)"Slots cannot be null");
        Collections.addAll(this.disabledSlots, slots);
    }

    public void removeDisabledSlots(EquipmentSlot ... slots) {
        Preconditions.checkNotNull((Object)slots, (Object)"Slots cannot be null");
        List.of(slots).forEach(this.disabledSlots::remove);
    }

    public boolean isSlotDisabled(@NotNull EquipmentSlot slot) {
        Preconditions.checkNotNull((Object)slot, (Object)"Slot cannot be null");
        return this.disabledSlots.contains(slot);
    }

    @NotNull
    public Rotations getBodyRotations() {
        throw new UnimplementedOperationException();
    }

    public void setBodyRotations(@NotNull Rotations rotations) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Rotations getLeftArmRotations() {
        throw new UnimplementedOperationException();
    }

    public void setLeftArmRotations(@NotNull Rotations rotations) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Rotations getRightArmRotations() {
        throw new UnimplementedOperationException();
    }

    public void setRightArmRotations(@NotNull Rotations rotations) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Rotations getLeftLegRotations() {
        throw new UnimplementedOperationException();
    }

    public void setLeftLegRotations(@NotNull Rotations rotations) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Rotations getRightLegRotations() {
        throw new UnimplementedOperationException();
    }

    public void setRightLegRotations(@NotNull Rotations rotations) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Rotations getHeadRotations() {
        throw new UnimplementedOperationException();
    }

    public void setHeadRotations(@NotNull Rotations rotations) {
        throw new UnimplementedOperationException();
    }
}

