/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.data.BlockDataMock;
import be.seeseemelk.mockbukkit.entity.MonsterMock;
import be.seeseemelk.mockbukkit.entity.data.EntityState;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.EntityType;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EndermanMock
extends MonsterMock
implements Enderman {
    @Nullable
    private BlockData carriedBlock = null;
    private boolean isScreaming = false;
    private boolean hasBeenStaredAt = false;

    public EndermanMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public boolean teleportRandomly() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public MaterialData getCarriedMaterial() {
        this.assertHasBlock();
        return new MaterialData(this.carriedBlock.getMaterial());
    }

    @Deprecated
    public void setCarriedMaterial(@NotNull MaterialData material) {
        Preconditions.checkNotNull((Object)material, (Object)"MaterialData cannot be null");
        this.carriedBlock = BlockDataMock.mock(material.getItemType());
    }

    @Nullable
    public BlockData getCarriedBlock() {
        this.assertHasBlock();
        return this.carriedBlock;
    }

    public void setCarriedBlock(@Nullable BlockData blockData) {
        Preconditions.checkNotNull((Object)blockData, (Object)"BlockData cannot be null");
        this.carriedBlock = blockData;
    }

    public boolean isScreaming() {
        return this.isScreaming;
    }

    public void setScreaming(boolean screaming) {
        this.isScreaming = screaming;
    }

    public boolean hasBeenStaredAt() {
        return this.hasBeenStaredAt;
    }

    public void setHasBeenStaredAt(boolean hasBeenStaredAt) {
        this.hasBeenStaredAt = hasBeenStaredAt;
    }

    public void assertHasBlock() {
        Preconditions.checkState((this.carriedBlock != null ? 1 : 0) != 0, (Object)"Carried Block must be set before using this method");
    }

    @Override
    protected EntityState getEntityState() {
        if (this.isScreaming()) {
            return EntityState.ANGRY;
        }
        return super.getEntityState();
    }

    @Override
    public EntityType getType() {
        return EntityType.ENDERMAN;
    }
}

