/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.WorldMock;
import be.seeseemelk.mockbukkit.entity.CowMock;
import be.seeseemelk.mockbukkit.entity.ItemEntityMock;
import be.seeseemelk.mockbukkit.util.AdventureConverters;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.MushroomCow;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MushroomCowMock
extends CowMock
implements MushroomCow {
    @NotNull
    private MushroomCow.Variant variant = MushroomCow.Variant.RED;

    public MushroomCowMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    @NotNull
    public MushroomCow.Variant getVariant() {
        return this.variant;
    }

    public void setVariant(@NotNull MushroomCow.Variant variant) {
        Preconditions.checkNotNull((Object)variant, (Object)"Variant cannot be null");
        this.variant = variant;
    }

    public int getStewEffectDuration() {
        throw new UnimplementedOperationException();
    }

    public void setStewEffectDuration(int duration) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public PotionEffectType getStewEffectType() {
        throw new UnimplementedOperationException();
    }

    public void setStewEffect(@Nullable PotionEffectType type) {
        throw new UnimplementedOperationException();
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.MUSHROOM_COW;
    }

    public void shear(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Sound.Source source) {
        WorldMock world = this.getWorld();
        Location location = this.getLocation();
        world.playSound((Entity)this, Sound.ENTITY_MOOSHROOM_SHEAR, AdventureConverters.soundSourceToCategory(source), 1.0f, 1.0f);
        Cow cow = world.spawn(this.getLocation(), Cow.class, null, CreatureSpawnEvent.SpawnReason.CUSTOM, true, false);
        cow.teleport((Entity)this);
        cow.setHealth(this.getHealth());
        if (this.customName() != null) {
            cow.customName(this.customName());
            cow.setCustomNameVisible(this.isCustomNameVisible());
        }
        cow.setPersistent(this.isPersistent());
        cow.setInvulnerable(this.isInvulnerable());
        if (!new EntityTransformEvent((Entity)this, List.of(cow), EntityTransformEvent.TransformReason.SHEARED).callEvent()) {
            cow.remove();
            return;
        }
        for (int i = 0; i < 5; ++i) {
            ItemEntityMock item = world.dropItem(location, new ItemStack(Material.valueOf((String)(this.getVariant().name() + "_MUSHROOM"))));
            if (new EntityDropItemEvent((Entity)this, (Item)item).callEvent()) continue;
            item.remove();
        }
        this.remove();
    }

    public boolean readyToBeSheared() {
        return !this.isDead() && this.isAdult();
    }
}

