/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.AnimalsMock;
import be.seeseemelk.mockbukkit.util.AdventureConverters;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Sheep;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SheepMock
extends AnimalsMock
implements Sheep {
    private boolean sheared = false;
    private DyeColor color = DyeColor.WHITE;

    public SheepMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public boolean isSheared() {
        return this.sheared;
    }

    public void setSheared(boolean flag) {
        this.sheared = flag;
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public void setColor(DyeColor color) {
        this.color = color;
    }

    @Override
    public EntityType getType() {
        return EntityType.SHEEP;
    }

    public void shear(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Sound.Source source) {
        this.getWorld().playSound((Entity)this, Sound.ENTITY_SHEEP_SHEAR, AdventureConverters.soundSourceToCategory(source), 1.0f, 1.0f);
        this.setSheared(true);
        int i = ThreadLocalRandom.current().nextInt(1, 4);
        for (int j = 0; j < i; ++j) {
            this.getWorld().dropItem(this.getLocation(), new ItemStack(Material.valueOf((String)(this.color.name() + "_WOOL"))));
        }
    }

    public boolean readyToBeSheared() {
        return !this.isDead() && !this.isSheared() && this.isAdult();
    }
}

