/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity.data;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.data.EntityState;
import be.seeseemelk.mockbukkit.entity.data.EntitySubType;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class EntityData {
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    private static final String STATES = "states";
    private final EntityType type;
    @NotNull
    private final String data;

    protected EntityData(@NotNull EntityType type, @NotNull String data) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)data);
        this.type = type;
        this.data = data;
    }

    public double getWidth(EntitySubType subType, EntityState state) {
        return this.getValueFromKey(WIDTH, subType, state).getAsDouble();
    }

    public double getHeight(EntitySubType subType, EntityState state) {
        return this.getValueFromKey(HEIGHT, subType, state).getAsDouble();
    }

    private JsonObject getStateMapping(EntitySubType subType, EntityState state) {
        try {
            JsonObject root = JsonParser.parseString((String)this.data).getAsJsonObject();
            JsonObject subTypeData = root.get(subType.getName()).getAsJsonObject();
            if (state == EntityState.DEFAULT) {
                return subTypeData.getAsJsonObject();
            }
            JsonObject statesData = subTypeData.getAsJsonObject().get(STATES).getAsJsonObject();
            return statesData.get(state.getName()).getAsJsonObject();
        }
        catch (IllegalStateException | NullPointerException e) {
            throw new UnimplementedOperationException("state " + state + " for entitytype " + this.type + ", " + subType + " is not implemented");
        }
    }

    public JsonElement getValueFromKey(String key, EntitySubType subType, EntityState state) {
        JsonElement value = this.getStateMapping(subType, state).get(key);
        if (value == null) {
            if (state == EntityState.DEFAULT) {
                throw new UnimplementedOperationException("datavalue " + key + " for entitytype " + this.type + " is not implemented");
            }
            return this.getValueFromKey(key, subType, EntityState.DEFAULT);
        }
        return value;
    }
}

