/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompassMetaMock
extends ItemMetaMock
implements CompassMeta {
    @Nullable
    private Location lodestone;
    private boolean tracked;

    public CompassMetaMock() {
    }

    public CompassMetaMock(@NotNull CompassMeta meta) {
        super((ItemMeta)meta);
        this.lodestone = meta.getLodestone();
        this.tracked = meta.isLodestoneTracked();
    }

    public boolean hasLodestone() {
        return this.lodestone != null;
    }

    @Nullable
    public Location getLodestone() {
        return this.lodestone;
    }

    public void setLodestone(@Nullable Location lodestone) {
        Preconditions.checkArgument((lodestone == null || lodestone.getWorld() != null ? 1 : 0) != 0, (Object)"world is null");
        this.lodestone = lodestone;
    }

    public boolean isLodestoneTracked() {
        return this.tracked;
    }

    public void setLodestoneTracked(boolean tracked) {
        this.tracked = tracked;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int hash = super.hashCode();
        hash = 31 * hash + (this.lodestone != null ? this.lodestone.hashCode() : 0);
        hash = 31 * hash + (this.tracked ? 1 : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CompassMeta)) {
            return false;
        }
        CompassMeta meta = (CompassMeta)obj;
        return super.equals(obj) && Objects.equals(this.lodestone, meta.getLodestone()) && this.tracked == meta.isLodestoneTracked();
    }

    @Override
    @NotNull
    public CompassMetaMock clone() {
        CompassMetaMock clone = (CompassMetaMock)super.clone();
        clone.lodestone = this.lodestone == null ? null : this.lodestone.clone();
        clone.tracked = this.tracked;
        return clone;
    }
}

