/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.plugin;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.plugin.MockBukkitPluginClassLoaderGroup;
import com.destroystokyo.paper.utils.PaperPluginLogger;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.provider.classloader.ConfiguredPluginClassLoader;
import io.papermc.paper.plugin.provider.classloader.PluginClassLoaderGroup;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import org.bukkit.Server;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockBukkitConfiguredPluginClassLoader
extends ClassLoader
implements ConfiguredPluginClassLoader {
    private final ServerMock server;
    private final PluginDescriptionFile description;
    private final File dataFolder;
    private final File pluginFile;
    private JarFile jarFile = null;
    private final PluginClassLoaderGroup classLoaderGroup = new MockBukkitPluginClassLoaderGroup();

    public MockBukkitConfiguredPluginClassLoader(ServerMock server, PluginDescriptionFile description, File dataFolder, File pluginFile) {
        this.server = server;
        this.description = description;
        this.dataFolder = dataFolder;
        this.pluginFile = pluginFile;
    }

    public void setJarFile(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    public PluginMeta getConfiguration() {
        return this.description;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class groupLoadedClass = this.classLoaderGroup.getClassByName(name, resolve, (ConfiguredPluginClassLoader)this);
        if (groupLoadedClass == null) {
            return super.loadClass(name, resolve);
        }
        return groupLoadedClass;
    }

    public Class<?> loadClass(@NotNull String name, boolean resolve, boolean checkGlobal, boolean checkLibraries) throws ClassNotFoundException {
        return this.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            if (this.jarFile == null) {
                throw new IllegalStateException("No jar file selected");
            }
            ZipEntry entry = this.jarFile.getEntry(name.replace('.', '/') + ".class");
            InputStream inputStream = this.jarFile.getInputStream(entry);
            byte[] array = inputStream.readAllBytes();
            return this.defineClass(name, array, 0, array.length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<? extends JavaPlugin> loadProxyClass(Class<? extends JavaPlugin> target) {
        DynamicType.Unloaded dynamicType = new ByteBuddy().subclass(target, (ConstructorStrategy)ConstructorStrategy.Default.IMITATE_SUPER_CLASS).name(target.getSimpleName() + "Proxy").make();
        return dynamicType.load((ClassLoader)this, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
    }

    public void init(JavaPlugin plugin) {
        plugin.init((Server)this.server, this.description, this.dataFolder, this.pluginFile, (ClassLoader)this, this.getConfiguration(), PaperPluginLogger.getLogger((PluginMeta)this.getConfiguration()));
    }

    @Nullable
    public JavaPlugin getPlugin() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public PluginClassLoaderGroup getGroup() {
        return this.classLoaderGroup;
    }

    public void close() throws IOException {
        throw new UnimplementedOperationException();
    }
}

