/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.scoreboard;

import com.google.common.base.Preconditions;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.RenderType;
import org.jetbrains.annotations.NotNull;

public class CriteriaMock
implements Criteria {
    private final String name;
    private final boolean readOnly;
    private final RenderType defaultRenderType;

    public CriteriaMock(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        this.name = name;
        this.readOnly = switch (name) {
            case "health", "food", "air", "armor", "xp", "level" -> true;
            default -> false;
        };
        this.defaultRenderType = "health".equals(name) ? RenderType.HEARTS : RenderType.INTEGER;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @NotNull
    public RenderType getDefaultRenderType() {
        return this.defaultRenderType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CriteriaMock that = (CriteriaMock)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

