/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.GameEventMock;
import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.MusicInstrumentMock;
import be.seeseemelk.mockbukkit.ReflectionAccessException;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.enchantments.EnchantmentMock;
import be.seeseemelk.mockbukkit.generator.structure.StructureMock;
import be.seeseemelk.mockbukkit.generator.structure.StructureTypeMock;
import be.seeseemelk.mockbukkit.inventory.meta.trim.TrimMaterialMock;
import be.seeseemelk.mockbukkit.inventory.meta.trim.TrimPatternMock;
import be.seeseemelk.mockbukkit.potion.MockPotionEffectType;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.papermc.paper.world.structure.ConfiguredStructure;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.bukkit.GameEvent;
import org.bukkit.Keyed;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructureType;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryMock<T extends Keyed>
implements Registry<T> {
    private final Map<NamespacedKey, T> keyedMap = new HashMap<NamespacedKey, T>();
    private JsonArray keyedData;
    private Function<JsonObject, T> constructor;

    RegistryMock(Class<T> tClass) {
        try {
            this.loadKeyedToRegistry(tClass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadKeyedToRegistry(Class<T> tClass) throws IOException {
        String classNameLowerCase = tClass.getSimpleName().toLowerCase();
        String fileName = "/keyed/" + classNameLowerCase + ".json";
        this.constructor = this.getConstructor(tClass);
        try (InputStream stream = MockBukkit.class.getResourceAsStream(fileName);){
            if (stream == null) {
                throw new FileNotFoundException(fileName);
            }
            JsonElement element = JsonParser.parseReader((Reader)new InputStreamReader(stream));
            this.keyedData = element.getAsJsonObject().get("values").getAsJsonArray();
        }
    }

    private Function<JsonObject, ? extends Keyed> getConstructor(Class<T> tClass) {
        if (tClass == Structure.class) {
            return StructureMock::new;
        }
        if (tClass == StructureType.class) {
            return StructureTypeMock::new;
        }
        if (tClass == TrimMaterial.class) {
            return TrimMaterialMock::new;
        }
        if (tClass == TrimPattern.class) {
            return TrimPatternMock::new;
        }
        if (tClass == MusicInstrument.class) {
            return MusicInstrumentMock::new;
        }
        if (tClass == GameEvent.class) {
            return GameEventMock::new;
        }
        if (tClass == Enchantment.class) {
            return EnchantmentMock::new;
        }
        if (tClass == PotionEffectType.class) {
            return MockPotionEffectType::new;
        }
        throw new UnimplementedOperationException();
    }

    public static <T extends Keyed> Registry<?> createRegistry(final Class<T> tClass) {
        if (tClass == ConfiguredStructure.class) {
            return new Registry<T>(){

                @Nullable
                public T get(@NotNull NamespacedKey key) {
                    throw new UnimplementedOperationException("Registry for type " + tClass + " not implemented");
                }

                @NotNull
                public Stream<T> stream() {
                    throw new UnimplementedOperationException("Registry for type " + tClass + " not implemented");
                }

                @NotNull
                public Iterator<T> iterator() {
                    throw new UnimplementedOperationException("Registry for type " + tClass + " not implemented");
                }
            };
        }
        if (RegistryMock.getOutlierKeyedClasses().contains(tClass)) {
            return new RegistryMock<T>(tClass);
        }
        return Stream.of(Registry.class.getDeclaredFields()).filter(a -> Registry.class.isAssignableFrom(a.getType())).filter(a -> Modifier.isPublic(a.getModifiers())).filter(a -> Modifier.isStatic(a.getModifiers())).filter(a -> RegistryMock.genericTypeMatches(a, tClass)).map(RegistryMock::getValue).filter(Objects::nonNull).findAny().orElseThrow(() -> new UnimplementedOperationException("Could not find registry for " + tClass.getSimpleName()));
    }

    private static boolean genericTypeMatches(Field a, Class<?> clazz) {
        Type type = a.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType type2 = (ParameterizedType)type;
            return type2.getActualTypeArguments()[0] == clazz;
        }
        return false;
    }

    private static Registry<?> getValue(Field a) {
        try {
            return (Registry)a.get(null);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionAccessException("Could not access field " + a.getDeclaringClass().getSimpleName() + "." + a.getName());
        }
    }

    private static List<Class<? extends Keyed>> getOutlierKeyedClasses() {
        return List.of(Structure.class, PotionEffectType.class, StructureType.class, TrimMaterial.class, TrimPattern.class, MusicInstrument.class, GameEvent.class, Enchantment.class);
    }

    @Nullable
    public T get(@NotNull NamespacedKey key) {
        Preconditions.checkNotNull((Object)key);
        this.loadIfEmpty();
        return (T)((Keyed)this.keyedMap.get(key));
    }

    @NotNull
    public Stream<T> stream() {
        this.loadIfEmpty();
        return this.keyedMap.values().stream();
    }

    @NotNull
    public Iterator<T> iterator() {
        this.loadIfEmpty();
        return this.keyedMap.values().iterator();
    }

    private void loadIfEmpty() {
        if (this.keyedMap.isEmpty()) {
            for (JsonElement structureJSONElement : this.keyedData) {
                JsonObject structureJSONObject = structureJSONElement.getAsJsonObject();
                Keyed tObject = (Keyed)this.constructor.apply(structureJSONObject);
                this.keyedMap.put(tObject.getKey(), tObject);
            }
        }
    }
}

