/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.ban;

import be.seeseemelk.mockbukkit.ban.MockIpBanEntry;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.BanEntry;
import org.bukkit.ban.IpBanList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockIpBanList
implements IpBanList {
    private final Map<String, BanEntry<InetAddress>> bans = new HashMap<String, BanEntry<InetAddress>>();
    private static final String TARGET_CANNOT_BE_NULL = "Target cannot be null";

    @Deprecated(since="1.20")
    @Nullable
    public BanEntry<InetAddress> getBanEntry(@NotNull String target) {
        Preconditions.checkNotNull((Object)target, (Object)TARGET_CANNOT_BE_NULL);
        return this.bans.getOrDefault(target, null);
    }

    @Nullable
    public BanEntry<InetAddress> getBanEntry(@NotNull InetAddress target) {
        Preconditions.checkNotNull((Object)target, (Object)TARGET_CANNOT_BE_NULL);
        return this.bans.getOrDefault(InetAddresses.toAddrString((InetAddress)target), null);
    }

    @Nullable
    public BanEntry<InetAddress> addBan(@NotNull String target, @Nullable String reason, @Nullable Date expires, @Nullable String source) {
        Preconditions.checkNotNull((Object)target, (Object)TARGET_CANNOT_BE_NULL);
        MockIpBanEntry entry = new MockIpBanEntry(target, reason == null || reason.isBlank() ? null : reason, expires, source == null || source.isBlank() ? null : source);
        this.bans.put(target, entry);
        return entry;
    }

    @Nullable
    public BanEntry<InetAddress> addBan(@NotNull InetAddress target, @Nullable String reason, @Nullable Date expires, @Nullable String source) {
        return this.addBan(InetAddresses.toAddrString((InetAddress)target), reason, expires, source);
    }

    @Nullable
    public BanEntry<InetAddress> addBan(@NotNull InetAddress target, @Nullable String reason, @Nullable Instant expires, @Nullable String source) {
        Date date = expires != null ? Date.from(expires) : null;
        return this.addBan(target, reason, date, source);
    }

    @Nullable
    public BanEntry<InetAddress> addBan(@NotNull InetAddress target, @Nullable String reason, @Nullable Duration duration, @Nullable String source) {
        Instant instant = duration != null ? Instant.now().plus(duration) : null;
        return this.addBan(target, reason, instant, source);
    }

    @Deprecated(since="1.20")
    @NotNull
    public Set<BanEntry> getBanEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String target : this.bans.keySet()) {
            BanEntry<InetAddress> banEntry = this.bans.get(target);
            if (banEntry == null) continue;
            builder.add(banEntry);
        }
        return builder.build();
    }

    @NotNull
    public Set<BanEntry<InetAddress>> getEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String target : this.bans.keySet()) {
            BanEntry<InetAddress> banEntry = this.bans.get(target);
            if (banEntry == null) continue;
            builder.add(banEntry);
        }
        return builder.build();
    }

    public boolean isBanned(@NotNull InetAddress target) {
        return this.bans.values().stream().anyMatch(banEntry -> ((InetAddress)banEntry.getBanTarget()).equals(target));
    }

    public boolean isBanned(@NotNull String target) {
        return this.bans.values().stream().anyMatch(banEntry -> InetAddresses.toAddrString((InetAddress)((InetAddress)banEntry.getBanTarget())).equals(target));
    }

    public void pardon(@NotNull InetAddress target) {
        Preconditions.checkNotNull((Object)target, (Object)TARGET_CANNOT_BE_NULL);
        this.pardon(InetAddresses.toAddrString((InetAddress)target));
    }

    public void pardon(@NotNull String target) {
        Preconditions.checkNotNull((Object)target, (Object)TARGET_CANNOT_BE_NULL);
        this.bans.remove(target);
    }
}

