/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.block.state.TileStateMock;
import be.seeseemelk.mockbukkit.inventory.InventoryMock;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerMock
extends TileStateMock
implements Container {
    private final Inventory inventory;
    @Nullable
    private Component customName;
    @NotNull
    private String lock = "";

    protected ContainerMock(@NotNull Material material) {
        super(material);
        this.inventory = this.createInventory();
    }

    protected ContainerMock(@NotNull Block block) {
        super(block);
        this.inventory = this.createInventory();
    }

    protected ContainerMock(@NotNull ContainerMock state) {
        super(state);
        this.inventory = state.getInventory();
        this.customName = state.customName();
        this.lock = state.getLock();
    }

    protected abstract InventoryMock createInventory();

    @Override
    @NotNull
    public abstract BlockState getSnapshot();

    public boolean isLocked() {
        return !this.lock.isEmpty();
    }

    @NotNull
    public String getLock() {
        return this.lock;
    }

    public void setLock(@Nullable String key) {
        this.lock = key == null ? "" : key;
    }

    @Nullable
    public Component customName() {
        return this.customName;
    }

    public void customName(@Nullable Component customName) {
        this.customName = customName;
    }

    @Nullable
    public String getCustomName() {
        return this.customName == null ? null : LegacyComponentSerializer.legacySection().serialize(this.customName);
    }

    public void setCustomName(@Nullable String name) {
        this.customName = name == null ? null : LegacyComponentSerializer.legacySection().deserialize(name);
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    @NotNull
    public Inventory getSnapshotInventory() {
        return ((InventoryMock)this.inventory).getSnapshot();
    }
}

