/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.state.TileStateMock;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreatureSpawnerMock
extends TileStateMock
implements CreatureSpawner {
    private EntityType spawnedType = EntityType.PIG;
    private int delay = 20;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int spawnCount = 4;
    private int maxNearbyEntities = 6;
    private int requiredPlayerRange = 16;
    private int spawnRange = 4;

    public CreatureSpawnerMock(@NotNull Material material) {
        super(material);
        this.checkType(material, Material.SPAWNER);
    }

    protected CreatureSpawnerMock(@NotNull Block block) {
        super(block);
        this.checkType(block, Material.SPAWNER);
    }

    protected CreatureSpawnerMock(@NotNull CreatureSpawnerMock state) {
        super(state);
        this.spawnedType = state.spawnedType;
        this.delay = state.delay;
        this.minSpawnDelay = state.minSpawnDelay;
        this.maxSpawnDelay = state.maxSpawnDelay;
        this.spawnCount = state.spawnCount;
        this.maxNearbyEntities = state.maxNearbyEntities;
        this.requiredPlayerRange = state.requiredPlayerRange;
        this.spawnRange = state.spawnRange;
    }

    @Override
    @NotNull
    public CreatureSpawnerMock getSnapshot() {
        return new CreatureSpawnerMock(this);
    }

    @NotNull
    public EntityType getSpawnedType() {
        return this.spawnedType;
    }

    public void setSpawnedType(@NotNull EntityType creatureType) {
        Preconditions.checkNotNull((Object)creatureType, (Object)"CreatureType cannot be null");
        this.spawnedType = creatureType;
    }

    public void setCreatureTypeByName(@NotNull String creatureType) {
        Preconditions.checkNotNull((Object)creatureType, (Object)"CreatureType cannot be null");
        EntityType type = EntityType.fromName((String)creatureType);
        if (type == null) {
            return;
        }
        this.setSpawnedType(type);
    }

    @NotNull
    public String getCreatureTypeName() {
        return this.getSpawnedType().name().toLowerCase();
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getMinSpawnDelay() {
        return this.minSpawnDelay;
    }

    public void setMinSpawnDelay(int delay) {
        Preconditions.checkArgument((delay <= this.getMaxSpawnDelay() ? 1 : 0) != 0, (Object)"Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        this.minSpawnDelay = delay;
    }

    public int getMaxSpawnDelay() {
        return this.maxSpawnDelay;
    }

    public void setMaxSpawnDelay(int delay) {
        Preconditions.checkArgument((delay > 0 ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument((delay >= this.getMinSpawnDelay() ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        this.maxSpawnDelay = delay;
    }

    public int getSpawnCount() {
        return this.spawnCount;
    }

    public void setSpawnCount(int spawnCount) {
        this.spawnCount = spawnCount;
    }

    public int getMaxNearbyEntities() {
        return this.maxNearbyEntities;
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        this.maxNearbyEntities = maxNearbyEntities;
    }

    public int getRequiredPlayerRange() {
        return this.requiredPlayerRange;
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        this.requiredPlayerRange = requiredPlayerRange;
    }

    public int getSpawnRange() {
        return this.spawnRange;
    }

    public void setSpawnRange(int spawnRange) {
        this.spawnRange = spawnRange;
    }

    @NotNull
    public List<SpawnerEntry> getPotentialSpawns() {
        throw new UnimplementedOperationException();
    }

    public void setPotentialSpawns(@NotNull Collection<SpawnerEntry> entries) {
        throw new UnimplementedOperationException();
    }

    public void addPotentialSpawn(@NotNull SpawnerEntry spawnerEntry) {
        throw new UnimplementedOperationException();
    }

    public void addPotentialSpawn(@NotNull EntitySnapshot snapshot, int weight, @Nullable SpawnRule spawnRule) {
        throw new UnimplementedOperationException();
    }

    public void setSpawnedEntity(@NotNull EntitySnapshot snapshot) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public EntitySnapshot getSpawnedEntity() {
        throw new UnimplementedOperationException();
    }

    public boolean isActivated() {
        if (!this.isPlaced()) {
            throw new IllegalStateException("Cannot reset the timer of a Spawner that isn't placed");
        }
        return Bukkit.getOnlinePlayers().stream().anyMatch(p -> p.getLocation().distance(this.getLocation()) <= (double)this.getRequiredPlayerRange());
    }

    public void resetTimer() {
        if (!this.isPlaced()) {
            throw new IllegalStateException("Cannot reset the timer of a Spawner that isn't placed");
        }
        this.delay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + ThreadLocalRandom.current().nextInt(this.maxSpawnDelay - this.minSpawnDelay);
    }

    public void setSpawnedItem(@NotNull ItemStack itemStack) {
        Preconditions.checkNotNull((Object)itemStack, (Object)"ItemStack cannot be null");
        this.setSpawnedType(EntityType.DROPPED_ITEM);
    }
}

