/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.state.TileStateMock;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.jetbrains.annotations.NotNull;

public class SignMock
extends TileStateMock
implements Sign {
    private final String[] lines = new String[]{"", "", "", ""};
    @NotNull
    private DyeColor color = DyeColor.BLACK;
    private boolean glowing = false;

    public SignMock(@NotNull Material material) {
        super(material);
        this.checkType(material, (Tag<Material>)Tag.SIGNS);
    }

    protected SignMock(@NotNull Block block) {
        super(block);
        this.checkType(block, (Tag<Material>)Tag.SIGNS);
    }

    protected SignMock(@NotNull SignMock state) {
        super(state);
        for (int i = 0; i < 4; ++i) {
            this.lines[i] = state.getLine(i);
        }
        this.color = state.getColor();
        this.glowing = state.isGlowingText();
    }

    @NotNull
    public List<Component> lines() {
        ArrayList<Component> components = new ArrayList<Component>();
        for (String line : this.lines) {
            components.add((Component)LegacyComponentSerializer.legacySection().deserialize(line));
        }
        return components;
    }

    @NotNull
    public Component line(int index) throws IndexOutOfBoundsException {
        return LegacyComponentSerializer.legacySection().deserialize(this.getLine(index));
    }

    public void line(int index, @NotNull Component line) throws IndexOutOfBoundsException {
        Preconditions.checkNotNull((Object)line, (Object)"Line cannot be null!");
        this.lines[index] = LegacyComponentSerializer.legacySection().serialize(line);
    }

    @Deprecated(since="1.16")
    @NotNull
    public @NotNull String @NotNull [] getLines() {
        String[] text = new String[4];
        for (int i = 0; i < 4; ++i) {
            text[i] = this.getLine(i);
        }
        return text;
    }

    @Deprecated(since="1.16")
    @NotNull
    public String getLine(int index) throws IndexOutOfBoundsException {
        return this.lines[index];
    }

    @Deprecated(since="1.16")
    public void setLine(int index, @NotNull String line) throws IndexOutOfBoundsException {
        this.lines[index] = line != null ? line : "";
    }

    public boolean isEditable() {
        throw new UnimplementedOperationException();
    }

    public void setEditable(boolean editable) {
        throw new UnimplementedOperationException();
    }

    public boolean isGlowingText() {
        return this.glowing;
    }

    public void setGlowingText(boolean glowing) {
        this.glowing = glowing;
    }

    @NotNull
    public DyeColor getColor() {
        return this.color;
    }

    public void setColor(@NotNull DyeColor color) {
        Preconditions.checkNotNull((Object)color, (Object)"Color can not be null!");
        this.color = color;
    }

    public boolean isWaxed() {
        throw new UnimplementedOperationException();
    }

    public void setWaxed(boolean waxed) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public SignSide getSide(@NotNull Side side) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Side getInteractableSideFor(double x, double z) {
        throw new UnimplementedOperationException();
    }

    @Override
    @NotNull
    public BlockState getSnapshot() {
        return new SignMock(this);
    }
}

