/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.state.TileStateMock;
import be.seeseemelk.mockbukkit.profile.PlayerProfileMock;
import com.destroystokyo.paper.MaterialTags;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.SkullType;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Rotatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkullMock
extends TileStateMock
implements Skull {
    private static final int MAX_OWNER_LENGTH = 16;
    @Nullable
    private PlayerProfileMock profile;

    public SkullMock(@NotNull Material material) {
        super(material);
        this.checkType(material, (Tag<Material>)MaterialTags.SKULLS);
    }

    protected SkullMock(@NotNull Block block) {
        super(block);
        this.checkType(block, (Tag<Material>)MaterialTags.SKULLS);
    }

    protected SkullMock(@NotNull SkullMock state) {
        super(state);
        this.profile = state.profile;
    }

    @Override
    @NotNull
    public BlockState getSnapshot() {
        return new SkullMock(this);
    }

    public boolean hasOwner() {
        return this.profile != null;
    }

    @Nullable
    public String getOwner() {
        return this.hasOwner() ? this.profile.getName() : null;
    }

    public boolean setOwner(@Nullable String name) {
        if (name == null) {
            return false;
        }
        Preconditions.checkArgument((name.length() <= 16 ? 1 : 0) != 0, (Object)"Name cannot be longer than 16 characters.");
        this.profile = new PlayerProfileMock(name, null);
        return true;
    }

    @Nullable
    public OfflinePlayer getOwningPlayer() {
        if (!this.hasOwner()) {
            return null;
        }
        if (this.profile.getId() != null) {
            return Bukkit.getOfflinePlayer((UUID)this.profile.getId());
        }
        if (this.profile.getName() != null) {
            return Bukkit.getOfflinePlayer((String)this.profile.getName());
        }
        return null;
    }

    public void setOwningPlayer(@NotNull OfflinePlayer player) {
        Preconditions.checkNotNull((Object)player, (Object)"Player cannot be null");
        this.profile = new PlayerProfileMock(player);
    }

    public void setPlayerProfile(@NotNull PlayerProfile profile) {
        Preconditions.checkArgument((boolean)(profile instanceof PlayerProfileMock), (Object)"Profile must be a PlayerProfileMock!");
        this.profile = (PlayerProfileMock)profile;
    }

    @Nullable
    public PlayerProfile getPlayerProfile() {
        return this.profile;
    }

    @Deprecated(since="1.18")
    public @Nullable org.bukkit.profile.PlayerProfile getOwnerProfile() {
        return !this.hasOwner() ? null : this.profile;
    }

    @Deprecated(since="1.18")
    public void setOwnerProfile(@Nullable org.bukkit.profile.PlayerProfile profile) {
        if (profile == null) {
            this.profile = null;
            return;
        }
        Preconditions.checkArgument((boolean)(profile instanceof PlayerProfileMock), (Object)"Profile must be a PlayerProfileMock!");
        PlayerProfileMock.validateSkullProfile((PlayerProfileMock)profile);
        this.profile = (PlayerProfileMock)profile;
    }

    @Nullable
    public NamespacedKey getNoteBlockSound() {
        throw new UnimplementedOperationException();
    }

    public void setNoteBlockSound(@Nullable NamespacedKey noteBlockSound) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BlockFace getRotation() {
        BlockData blockData = this.getBlockData();
        return blockData instanceof Rotatable ? ((Rotatable)blockData).getRotation() : ((Directional)blockData).getFacing();
    }

    public void setRotation(@NotNull BlockFace rotation) {
        BlockData blockData = this.getBlockData();
        if (blockData instanceof Rotatable) {
            Rotatable rotatable = (Rotatable)blockData;
            rotatable.setRotation(rotation);
        } else if (blockData instanceof Directional) {
            Directional directional = (Directional)blockData;
            directional.setFacing(rotation);
        }
        this.setBlockData(blockData);
    }

    @Deprecated(since="1.13")
    @NotNull
    public SkullType getSkullType() {
        return switch (this.getType()) {
            case Material.SKELETON_SKULL, Material.SKELETON_WALL_SKULL -> SkullType.SKELETON;
            case Material.WITHER_SKELETON_SKULL, Material.WITHER_SKELETON_WALL_SKULL -> SkullType.WITHER;
            case Material.ZOMBIE_HEAD, Material.ZOMBIE_WALL_HEAD -> SkullType.ZOMBIE;
            case Material.PLAYER_HEAD, Material.PLAYER_WALL_HEAD -> SkullType.PLAYER;
            case Material.CREEPER_HEAD, Material.CREEPER_WALL_HEAD -> SkullType.CREEPER;
            case Material.DRAGON_HEAD, Material.DRAGON_WALL_HEAD -> SkullType.DRAGON;
            default -> throw new IllegalArgumentException("Unknown SkullType for " + this.getType());
        };
    }

    @Deprecated(since="1.13")
    public void setSkullType(SkullType skullType) {
        throw new UnsupportedOperationException("Must change block type");
    }
}

