/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.data.BlockDataMock;
import be.seeseemelk.mockbukkit.entity.MonsterMock;
import be.seeseemelk.mockbukkit.entity.data.EntityState;
import com.google.common.base.Preconditions;
import java.util.SplittableRandom;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.material.MaterialData;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EndermanMock
extends MonsterMock
implements Enderman {
    private static final SplittableRandom random = new SplittableRandom();
    @Nullable
    private BlockData carriedBlock = null;
    private boolean isScreaming = false;
    private boolean hasBeenStaredAt = false;

    public EndermanMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public boolean teleportRandomly() {
        throw new UnimplementedOperationException();
    }

    @Deprecated(since="1.18")
    @NotNull
    public MaterialData getCarriedMaterial() {
        this.assertHasBlock();
        return new MaterialData(this.carriedBlock.getMaterial());
    }

    @Deprecated(since="1.18")
    public void setCarriedMaterial(@NotNull MaterialData material) {
        Preconditions.checkNotNull((Object)material, (Object)"MaterialData cannot be null");
        this.carriedBlock = BlockDataMock.mock(material.getItemType());
    }

    @Nullable
    public BlockData getCarriedBlock() {
        this.assertHasBlock();
        return this.carriedBlock;
    }

    public void setCarriedBlock(@Nullable BlockData blockData) {
        Preconditions.checkNotNull((Object)blockData, (Object)"BlockData cannot be null");
        this.carriedBlock = blockData;
    }

    public boolean teleport() {
        if (this.alive) {
            double x = this.getLocation().x() + (random.nextDouble() - 0.5) * 64.0;
            double y = this.getLocation().y() + (double)(random.nextInt(64) - 32);
            double z = this.getLocation().z() + (random.nextDouble() - 0.5) * 64.0;
            return this.teleport(new Location((World)this.getWorld(), x, y, z));
        }
        return false;
    }

    public boolean teleportTowards(@NotNull Entity entity) {
        if (this.alive) {
            Vector vector = new Vector(this.getLocation().x() - entity.getLocation().x(), this.getLocation().y() + 1.45 - entity.getLocation().y(), this.getLocation().z() - entity.getLocation().z());
            vector = vector.normalize();
            double x = this.getLocation().x() + (random.nextDouble() - 0.5) * 8.0 - vector.getX() * 16.0;
            double y = this.getLocation().y() + (double)(random.nextInt(16) - 8) - vector.getY() * 16.0;
            double z = this.getLocation().z() + (random.nextDouble() - 0.5) * 8.0 - vector.getZ() * 16.0;
            return this.teleport(new Location((World)this.getWorld(), x, y, z));
        }
        return false;
    }

    public boolean isScreaming() {
        return this.isScreaming;
    }

    public void setScreaming(boolean screaming) {
        this.isScreaming = screaming;
    }

    public boolean hasBeenStaredAt() {
        return this.hasBeenStaredAt;
    }

    public void setHasBeenStaredAt(boolean hasBeenStaredAt) {
        this.hasBeenStaredAt = hasBeenStaredAt;
    }

    public void assertHasBlock() {
        Preconditions.checkState((this.carriedBlock != null ? 1 : 0) != 0, (Object)"Carried Block must be set before using this method");
    }

    @Override
    protected EntityState getEntityState() {
        if (this.isScreaming()) {
            return EntityState.ANGRY;
        }
        return super.getEntityState();
    }

    @Override
    public EntityType getType() {
        return EntityType.ENDERMAN;
    }
}

