/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.MinecartMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.jetbrains.annotations.NotNull;

public class ExplosiveMinecartMock
extends MinecartMock
implements ExplosiveMinecart {
    private int fuseTicks = -1;

    public ExplosiveMinecartMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public void setFuseTicks(int ticks) {
        this.fuseTicks = ticks;
    }

    public int getFuseTicks() {
        return this.fuseTicks;
    }

    public void ignite() {
        this.fuseTicks = 80;
    }

    public boolean isIgnited() {
        return this.fuseTicks > -1;
    }

    public void explode() {
        double x = this.getVelocity().getX();
        double z = this.getVelocity().getZ();
        this.explode(x * x + z * z);
    }

    public void explode(double power) {
        Preconditions.checkArgument((0.0 <= power && power <= 5.0 ? 1 : 0) != 0, (String)"Power must be in range [0, 5] (got %s)", (Object)power);
        double d1 = Math.sqrt(power);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.server.getPluginManager().callEvent((Event)new ExplosionPrimeEvent((Entity)this, (float)(4.0 + random.nextDouble() * 1.5 * d1), false));
        this.remove();
    }

    @NotNull
    public Material getMinecartMaterial() {
        return Material.TNT_MINECART;
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.MINECART_TNT;
    }
}

