/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.ChestedHorseMock;
import be.seeseemelk.mockbukkit.entity.MockRangedEntity;
import be.seeseemelk.mockbukkit.inventory.LlamaInventoryMock;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;

public class LlamaMock
extends ChestedHorseMock
implements Llama,
MockRangedEntity<LlamaMock> {
    @NotNull
    private Llama.Color color = Llama.Color.BROWN;
    private int strength = 1;
    private final Map<LivingEntity, Pair<Float, Boolean>> attackedMobs = new HashMap<LivingEntity, Pair<Float, Boolean>>();
    private boolean isAgressive = false;
    @NotNull
    private final LlamaInventoryMock inventory = new LlamaInventoryMock((InventoryHolder)this);
    private LlamaMock caravanaHead;
    private LlamaMock caravanaTail;

    public LlamaMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    @NotNull
    public Llama.Color getColor() {
        return this.color;
    }

    public void setColor(@NotNull Llama.Color color) {
        Preconditions.checkNotNull((Object)color, (Object)"Color cannot be null");
        this.color = color;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setStrength(int strength) {
        Preconditions.checkArgument((strength >= 1 && strength <= 5 ? 1 : 0) != 0, (Object)"Strength cannot be negative");
        this.strength = strength;
    }

    @Override
    public void rangedAttack(@NotNull LivingEntity target, float charge) {
        Preconditions.checkNotNull((Object)target, (Object)"Target cannot be null");
        Preconditions.checkArgument((charge >= 0.0f && charge <= 1.0f ? 1 : 0) != 0, (Object)"Charge must be between 0 and 1");
        this.attackedMobs.put(target, (Pair<Float, Boolean>)Pair.of((Object)Float.valueOf(charge), (Object)this.isAgressive));
    }

    @Override
    public void setChargingAttack(boolean raiseHands) {
        this.isAgressive = raiseHands;
    }

    public void assertAttacked(LivingEntity entity, float charge) {
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null");
        Preconditions.checkArgument((charge >= 0.0f && charge <= 1.0f ? 1 : 0) != 0, (Object)"Charge must be between 0 and 1");
        if (!this.attackedMobs.containsKey(entity) || ((Float)this.attackedMobs.get(entity).getLeft()).floatValue() != charge) {
            Assertions.fail();
        }
    }

    public void assertAgressiveAttack(LivingEntity entity, float charge) {
        this.assertAttacked(entity, charge);
        if (!((Boolean)this.attackedMobs.get(entity).getRight()).booleanValue()) {
            Assertions.fail();
        }
    }

    @Deprecated(since="1.11")
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Horse.Variant getVariant() {
        return Horse.Variant.LLAMA;
    }

    @Override
    @NotNull
    public LlamaInventoryMock getInventory() {
        return this.inventory;
    }

    public boolean inCaravan() {
        return this.caravanaHead != null;
    }

    public void joinCaravan(@NotNull Llama llama) {
        Preconditions.checkNotNull((Object)llama, (Object)"Llama cannot be null");
        this.caravanaHead = (LlamaMock)llama;
        ((LlamaMock)llama).caravanaTail = this;
    }

    public void leaveCaravan() {
        if (this.caravanaHead != null) {
            this.caravanaHead.caravanaTail = null;
            this.caravanaHead = null;
        }
    }

    @Nullable
    public Llama getCaravanHead() {
        return this.caravanaHead;
    }

    public boolean hasCaravanTail() {
        return this.caravanaTail != null;
    }

    @Nullable
    public Llama getCaravanTail() {
        return this.caravanaTail;
    }

    public boolean isChargingAttack() {
        return this.isAgressive;
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.LLAMA;
    }
}

