/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.SchoolableFishMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TropicalFishMock
extends SchoolableFishMock
implements TropicalFish {
    @NotNull
    private DyeColor patternColor = DyeColor.values()[ThreadLocalRandom.current().nextInt(DyeColor.values().length)];
    @NotNull
    private DyeColor bodyColor = DyeColor.values()[ThreadLocalRandom.current().nextInt(DyeColor.values().length)];
    @NotNull
    private TropicalFish.Pattern pattern = TropicalFish.Pattern.values()[ThreadLocalRandom.current().nextInt(TropicalFish.Pattern.values().length)];

    public TropicalFishMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    @NotNull
    public ItemStack getBaseBucketItem() {
        return new ItemStack(Material.TROPICAL_FISH_BUCKET);
    }

    @NotNull
    public DyeColor getPatternColor() {
        return this.patternColor;
    }

    public void setPatternColor(@NotNull DyeColor color) {
        Preconditions.checkNotNull((Object)color, (Object)"Pattern Color cannot be null");
        this.patternColor = color;
    }

    @NotNull
    public DyeColor getBodyColor() {
        return this.bodyColor;
    }

    public void setBodyColor(@NotNull DyeColor color) {
        Preconditions.checkNotNull((Object)color, (Object)"Body Color cannot be null");
        this.bodyColor = color;
    }

    @NotNull
    public TropicalFish.Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(@NotNull TropicalFish.Pattern pattern) {
        Preconditions.checkNotNull((Object)pattern, (Object)"Pattern cannot be null");
        this.pattern = pattern;
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.TROPICAL_FISH;
    }
}

