/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.MonsterMock;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Warden;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WardenMock
extends MonsterMock
implements Warden {
    private final Map<Entity, Integer> angerPerEntity = new HashMap<Entity, Integer>();

    public WardenMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public int getAnger() {
        throw new UnimplementedOperationException();
    }

    public int getAnger(@NotNull Entity entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null");
        return this.angerPerEntity.getOrDefault(entity, 0);
    }

    public int getHighestAnger() {
        throw new UnimplementedOperationException();
    }

    public void increaseAnger(@NotNull Entity entity, int increase) {
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null");
        if (this.angerPerEntity.containsKey(entity)) {
            int newAnger = this.angerPerEntity.get(entity) + increase;
            Preconditions.checkState((newAnger <= 150 ? 1 : 0) != 0, (Object)"Anger can't be higher than 150");
            this.angerPerEntity.put(entity, newAnger);
        } else {
            Preconditions.checkState((increase <= 150 ? 1 : 0) != 0, (Object)"Anger can't be higher than 150");
            this.angerPerEntity.put(entity, increase);
        }
    }

    public void setAnger(@NotNull Entity entity, int anger) {
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null");
        Preconditions.checkArgument((anger <= 150 ? 1 : 0) != 0, (Object)"Anger can't be higher than 150");
        this.angerPerEntity.put(entity, anger);
    }

    public void clearAnger(@NotNull Entity entity) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public LivingEntity getEntityAngryAt() {
        throw new UnimplementedOperationException();
    }

    public void setDisturbanceLocation(@NotNull Location location) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Warden.AngerLevel getAngerLevel() {
        if (this.getAnger() <= 39) {
            return Warden.AngerLevel.CALM;
        }
        if (this.getAnger() <= 79) {
            return Warden.AngerLevel.AGITATED;
        }
        return Warden.AngerLevel.ANGRY;
    }

    @Override
    public EntityType getType() {
        return EntityType.WARDEN;
    }
}

