/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity.data;

import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.entity.data.EntityData;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.entity.EntityType;

public class EntityDataRegistry {
    static final Map<EntityType, String> entityJsonDataMap = new HashMap<EntityType, String>();

    private EntityDataRegistry() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void loadData(String repository) {
        for (EntityType type : EntityType.values()) {
            try {
                entityJsonDataMap.put(type, EntityDataRegistry.load(repository, type));
            }
            catch (IOException e) {
                entityJsonDataMap.put(type, "");
            }
        }
    }

    private static String load(String repository, EntityType type) throws IOException {
        String path = repository + type.toString().toLowerCase() + ".json";
        if (MockBukkit.class.getResource(path) == null) {
            throw new FileNotFoundException(path);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(MockBukkit.class.getResourceAsStream(path), StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining(""));
            return string;
        }
    }

    public static EntityData loadEntityData(EntityType type) {
        if (entityJsonDataMap.isEmpty()) {
            EntityDataRegistry.loadData("/entities/");
        }
        String data = entityJsonDataMap.get(type);
        return new EntityData(type, data);
    }
}

