/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.help;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.help.HelpMap;
import org.bukkit.help.HelpTopic;
import org.bukkit.help.HelpTopicComparator;
import org.bukkit.help.HelpTopicFactory;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;

public class HelpMapMock
implements HelpMap {
    private HelpTopic defaultTopic;
    private final Map<String, HelpTopic> topics = new TreeMap<String, HelpTopic>((Comparator<String>)HelpTopicComparator.topicNameComparatorInstance());
    private final Map<Class<?>, HelpTopicFactory<?>> factories = new HashMap();

    public HelpTopic getHelpTopic(@NotNull String topicName) {
        Preconditions.checkNotNull((Object)topicName, (Object)"TopicName cannot be null");
        return topicName.isEmpty() ? this.defaultTopic : this.topics.get(topicName);
    }

    @NotNull
    public Collection<HelpTopic> getHelpTopics() {
        return this.topics.values();
    }

    public void addTopic(@NotNull HelpTopic topic) {
        Preconditions.checkNotNull((Object)topic, (Object)"Topic cannot be null");
        Preconditions.checkNotNull((Object)topic.getName(), (Object)"Topic name cannot be null");
        if (topic.getName().isEmpty()) {
            this.defaultTopic = topic;
        } else {
            this.topics.put(topic.getName(), topic);
        }
    }

    public void clear() {
        this.topics.clear();
    }

    @NotNull
    public List<String> getIgnoredPlugins() {
        throw new UnimplementedOperationException();
    }

    public void registerHelpTopicFactory(@NotNull Class<?> commandClass, @NotNull HelpTopicFactory<?> factory) {
        Preconditions.checkNotNull(commandClass, (Object)"CommandClass cannot be null");
        Preconditions.checkNotNull(factory, (Object)"Factory cannot be null");
        if (!Command.class.isAssignableFrom(commandClass) && !CommandExecutor.class.isAssignableFrom(commandClass)) {
            throw new IllegalArgumentException("CommandClass must inherit from types Command or CommandExecutor");
        }
        this.factories.put(commandClass, factory);
    }

    public void assertRegistered(@NotNull HelpTopicFactory<?> factory) {
        Preconditions.checkNotNull(factory, (Object)"Factory cannot be null");
        Assertions.assertTrue((boolean)this.factories.containsValue(factory));
    }
}

