/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.bukkit.Color;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotionMetaMock
extends ItemMetaMock
implements PotionMeta {
    @NotNull
    private List<PotionEffect> effects = new ArrayList<PotionEffect>();
    @NotNull
    private PotionData basePotionData = new PotionData(PotionType.UNCRAFTABLE);
    @Nullable
    private Color color;

    public PotionMetaMock() {
    }

    public PotionMetaMock(@NotNull PotionMeta meta) {
        super((ItemMeta)meta);
        this.effects = new ArrayList<PotionEffect>(meta.getCustomEffects());
        this.basePotionData = meta.getBasePotionData();
        this.color = meta.getColor();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.effects.hashCode();
        result = 31 * result + this.basePotionData.hashCode();
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PotionMetaMock)) {
            return false;
        }
        PotionMetaMock other = (PotionMetaMock)obj;
        return this.effects.equals(other.effects) && Objects.equals(this.color, other.color) && this.basePotionData.equals((Object)other.basePotionData);
    }

    @Override
    @NotNull
    public PotionMetaMock clone() {
        PotionMetaMock mock = (PotionMetaMock)super.clone();
        mock.effects = new ArrayList<PotionEffect>(this.effects);
        mock.color = this.color == null ? null : Color.fromRGB((int)this.color.asRGB());
        return mock;
    }

    public boolean addCustomEffect(@NotNull PotionEffect effect, boolean overwrite) {
        int index = this.indexOf(effect.getType());
        if (index == -1) {
            this.effects.add(effect);
            return true;
        }
        if (!overwrite) {
            return false;
        }
        PotionEffect prev = this.effects.get(index);
        if (prev.getDuration() == effect.getDuration()) {
            return false;
        }
        this.effects.set(index, effect);
        return true;
    }

    public boolean clearCustomEffects() {
        boolean empty = this.effects.isEmpty();
        this.effects.clear();
        return !empty;
    }

    @NotNull
    public List<PotionEffect> getCustomEffects() {
        return ImmutableList.copyOf(this.effects);
    }

    public boolean hasCustomEffect(@NotNull PotionEffectType type) {
        return this.indexOf(type) != -1;
    }

    public boolean hasCustomEffects() {
        return !this.effects.isEmpty();
    }

    public boolean removeCustomEffect(@NotNull PotionEffectType type) {
        Iterator<PotionEffect> iterator = this.effects.iterator();
        boolean changed = false;
        while (iterator.hasNext()) {
            PotionEffect effect = iterator.next();
            if (!type.equals(effect.getType())) continue;
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    private int indexOf(PotionEffectType type) {
        for (int i = 0; i < this.effects.size(); ++i) {
            if (!this.effects.get(i).getType().equals(type)) continue;
            return i;
        }
        return -1;
    }

    public boolean hasColor() {
        return this.color != null;
    }

    @Nullable
    public Color getColor() {
        return this.color == null ? null : Color.fromRGB((int)this.color.asRGB());
    }

    public void setColor(@Nullable Color color) {
        this.color = color == null ? null : Color.fromRGB((int)color.asRGB());
    }

    @Deprecated(since="1.20")
    public void setBasePotionData(@NotNull PotionData data) {
        this.basePotionData = new PotionData(data.getType(), data.isExtended(), data.isUpgraded());
    }

    @Deprecated(since="1.20")
    @NotNull
    public PotionData getBasePotionData() {
        return new PotionData(this.basePotionData.getType(), this.basePotionData.isExtended(), this.basePotionData.isUpgraded());
    }

    public void setBasePotionType(@NotNull PotionType type) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public PotionType getBasePotionType() {
        throw new UnimplementedOperationException();
    }

    @Deprecated(since="1.9")
    public boolean setMainEffect(@NotNull PotionEffectType type) {
        throw new UnimplementedOperationException();
    }
}

