/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.potion;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.util.EnumMap;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class MockPotionEffectType
extends PotionEffectType {
    private final int id;
    private final String name;
    private final boolean instant;
    private final Color color;
    @NotNull
    private final Map<Attribute, AttributeModifier> attributeModifiers;
    private final NamespacedKey key;
    private final PotionEffectType.Category category;

    public MockPotionEffectType(@NotNull NamespacedKey key, int id, String name, boolean instant, Color color, PotionEffectType.Category category) {
        this.key = (NamespacedKey)Preconditions.checkNotNull((Object)key);
        this.id = id;
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.instant = instant;
        this.color = (Color)Preconditions.checkNotNull((Object)color);
        this.attributeModifiers = new EnumMap<Attribute, AttributeModifier>(Attribute.class);
        this.category = category;
    }

    public MockPotionEffectType(@NotNull NamespacedKey key, int id, String name, boolean instant, Color color) {
        this(key, id, name, instant, color, PotionEffectType.Category.NEUTRAL);
    }

    public MockPotionEffectType(JsonObject data) {
        this(NamespacedKey.fromString((String)data.get("key").getAsString()), data.get("id").getAsInt(), data.get("name").getAsString(), data.get("instant").getAsBoolean(), Color.fromRGB((int)data.get("rgb").getAsInt()), PotionEffectType.Category.valueOf((String)data.get("category").getAsString()));
    }

    @Deprecated
    public double getDurationModifier() {
        return 1.0;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Deprecated(since="1.20")
    public int getId() {
        return this.id;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @NotNull
    public PotionEffect createEffect(int duration, int amplifier) {
        return new PotionEffect((PotionEffectType)this, this.isInstant() ? 1 : (int)((double)duration * this.getDurationModifier()), amplifier);
    }

    public boolean isInstant() {
        return this.instant;
    }

    @NotNull
    public Color getColor() {
        return this.color;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PotionEffectType) {
            return this.id == ((PotionEffectType)obj).getId();
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public void addAttributeModifier(Attribute attribute, AttributeModifier modifier) {
        this.attributeModifiers.put(attribute, modifier);
    }

    @NotNull
    public Map<Attribute, AttributeModifier> getEffectAttributes() {
        return ImmutableMap.copyOf(this.attributeModifiers);
    }

    public double getAttributeModifierAmount(@NotNull Attribute attribute, int effectAmplifier) {
        Preconditions.checkArgument((effectAmplifier >= 0 ? 1 : 0) != 0, (Object)"effectAmplifier must be greater than or equal to 0");
        Preconditions.checkArgument((boolean)this.attributeModifiers.containsKey(attribute), (Object)(attribute + " is not present on " + this.getKey()));
        return this.getAttributeModifierValue(effectAmplifier, this.attributeModifiers.get(attribute));
    }

    private double getAttributeModifierValue(int amplifier, @NotNull AttributeModifier modifier) {
        return modifier.getAmount() * (double)(amplifier + 1);
    }

    @NotNull
    public PotionEffectType.Category getEffectCategory() {
        return this.category;
    }

    @NotNull
    public String translationKey() {
        throw new UnimplementedOperationException();
    }
}

