/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.scoreboard;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.scoreboard.ObjectiveMock;
import net.kyori.adventure.text.Component;
import org.bukkit.OfflinePlayer;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScoreMock
implements Score {
    private final ObjectiveMock objective;
    private final String entry;
    @Nullable
    private OfflinePlayer player = null;
    private int score = 0;
    private boolean set = false;

    public ScoreMock(ObjectiveMock objective, String entry) {
        this.objective = objective;
        this.entry = entry;
    }

    public void setPlayer(OfflinePlayer player) {
        this.player = player;
    }

    @Deprecated(since="1.7.10")
    @NotNull
    public OfflinePlayer getPlayer() {
        return this.player;
    }

    @NotNull
    public String getEntry() {
        return this.entry;
    }

    @NotNull
    public ObjectiveMock getObjective() {
        return this.objective;
    }

    public int getScore() throws IllegalStateException {
        if (this.objective.isRegistered()) {
            return this.score;
        }
        throw new IllegalStateException("Objective is not registered");
    }

    public void setScore(int score) throws IllegalStateException {
        this.score = score;
        this.set = true;
    }

    public boolean isScoreSet() throws IllegalStateException {
        return this.set;
    }

    public Scoreboard getScoreboard() {
        return this.objective.getScoreboard();
    }

    public void resetScore() throws IllegalStateException {
        this.score = 0;
        this.set = false;
    }

    public boolean isTriggerable() {
        throw new UnimplementedOperationException();
    }

    public void setTriggerable(boolean triggerable) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Component customName() {
        throw new UnimplementedOperationException();
    }

    public void customName(@Nullable Component customName) {
        throw new UnimplementedOperationException();
    }
}

