/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.scoreboard;

import be.seeseemelk.mockbukkit.entity.EntityMock;
import be.seeseemelk.mockbukkit.scoreboard.ObjectiveMock;
import be.seeseemelk.mockbukkit.scoreboard.TeamMock;
import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScoreboardMock
implements Scoreboard {
    private static final String OFFLINE_PLAYER_CANNOT_BE_NULL = "OfflinePlayer cannot be null";
    private static final String ENTITY_CANNOT_BE_NULL = "Entity cannot be null";
    @NotNull
    private final Map<String, ObjectiveMock> objectives = new HashMap<String, ObjectiveMock>();
    @NotNull
    private final Map<DisplaySlot, ObjectiveMock> objectivesByDisplaySlot = new EnumMap<DisplaySlot, ObjectiveMock>(DisplaySlot.class);
    @NotNull
    private final Map<String, Team> teams = new HashMap<String, Team>();

    @Deprecated(since="1.13")
    @NotNull
    public ObjectiveMock registerNewObjective(@NotNull String name, @NotNull String criteria) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, name, RenderType.INTEGER);
    }

    @NotNull
    public ObjectiveMock registerNewObjective(@NotNull String name, @NotNull String criteria, @Nullable Component displayName) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, displayName, RenderType.INTEGER);
    }

    @NotNull
    public ObjectiveMock registerNewObjective(@NotNull String name, @NotNull String criteria, @Nullable Component displayName, @NotNull RenderType renderType) throws IllegalArgumentException {
        return this.registerNewObjective(name, Criteria.create((String)criteria), displayName, renderType);
    }

    @NotNull
    public ObjectiveMock registerNewObjective(@NotNull String name, @NotNull Criteria criteria, @Nullable Component displayName) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, displayName, RenderType.INTEGER);
    }

    @NotNull
    public ObjectiveMock registerNewObjective(@NotNull String name, @NotNull Criteria criteria, @Nullable Component displayName, @NotNull RenderType renderType) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)name, (Object)"Objective name cannot be null");
        Preconditions.checkNotNull((Object)criteria, (Object)"Criteria cannot be null");
        Preconditions.checkNotNull((Object)displayName, (Object)"Display name cannot be null");
        Preconditions.checkNotNull((Object)renderType, (Object)"RenderType cannot be null");
        Preconditions.checkArgument((name.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (Object)("The name '" + name + "' is longer than the limit of 32767 characters"));
        Preconditions.checkArgument((!this.objectives.containsKey(name) ? 1 : 0) != 0, (Object)("An objective of name '" + name + "' already exists"));
        ObjectiveMock objective = new ObjectiveMock(this, name, displayName, criteria, renderType);
        this.objectives.put(name, objective);
        return objective;
    }

    @Deprecated(since="1.16")
    @NotNull
    public ObjectiveMock registerNewObjective(@NotNull String name, @NotNull String criteria, @NotNull String displayName) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, displayName, RenderType.INTEGER);
    }

    @Deprecated(since="1.16")
    @NotNull
    public ObjectiveMock registerNewObjective(@NotNull String name, @NotNull String criteria, @NotNull String displayName, @NotNull RenderType renderType) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, (Component)LegacyComponentSerializer.legacySection().deserialize(displayName), renderType);
    }

    @NotNull
    public ObjectiveMock registerNewObjective(@NotNull String name, @NotNull Criteria criteria, @NotNull String displayName) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, displayName, RenderType.INTEGER);
    }

    @NotNull
    public ObjectiveMock registerNewObjective(@NotNull String name, @NotNull Criteria criteria, @NotNull String displayName, @NotNull RenderType renderType) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, (Component)LegacyComponentSerializer.legacySection().deserialize(displayName), renderType);
    }

    public ObjectiveMock getObjective(@NotNull String name) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        return this.objectives.get(name);
    }

    @NotNull
    public Set<Objective> getObjectivesByCriteria(@NotNull String criteria) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)criteria, (Object)"Criteria cannot be null");
        return this.objectives.values().stream().filter(objective -> objective.getCriteria().equals(criteria)).collect(Collectors.toSet());
    }

    @NotNull
    public Set<Objective> getObjectivesByCriteria(@NotNull Criteria criteria) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)criteria, (Object)"Criteria cannot be null");
        return this.objectives.values().stream().filter(objective -> objective.getTrackedCriteria().equals(criteria)).collect(Collectors.toSet());
    }

    @NotNull
    public Set<Objective> getObjectives() {
        return Set.copyOf(this.objectives.values());
    }

    public ObjectiveMock getObjective(@NotNull DisplaySlot slot) throws IllegalArgumentException {
        return this.objectivesByDisplaySlot.get(slot);
    }

    @NotNull
    public Set<Score> getScores(@NotNull OfflinePlayer player) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)player, (Object)OFFLINE_PLAYER_CANNOT_BE_NULL);
        return this.getScores(player.getName());
    }

    @NotNull
    public Set<Score> getScores(@NotNull String entry) throws IllegalArgumentException {
        HashSet<Score> scores = new HashSet<Score>();
        for (Objective objective : this.objectives.values()) {
            scores.add(objective.getScore(entry));
        }
        return scores;
    }

    public void resetScores(@NotNull OfflinePlayer player) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)player, (Object)OFFLINE_PLAYER_CANNOT_BE_NULL);
        this.resetScores(player.getName());
    }

    public void resetScores(@NotNull String entry) throws IllegalArgumentException {
        for (Objective objective : this.objectives.values()) {
            objective.getScore(entry).setScore(0);
        }
    }

    public Team getPlayerTeam(@NotNull OfflinePlayer player) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)player, (Object)OFFLINE_PLAYER_CANNOT_BE_NULL);
        return this.getEntryTeam(player.getName());
    }

    public Team getEntryTeam(@NotNull String entry) throws IllegalArgumentException {
        for (Team t : this.teams.values()) {
            if (!t.hasEntry(entry)) continue;
            return t;
        }
        return null;
    }

    public Team getTeam(@NotNull String teamName) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)teamName, (Object)"Team name cannot be null");
        return this.teams.get(teamName);
    }

    @NotNull
    public Set<Team> getTeams() {
        return Set.copyOf(this.teams.values());
    }

    @NotNull
    public Team registerNewTeam(@NotNull String name) throws IllegalArgumentException {
        if (this.teams.containsKey(name)) {
            throw new IllegalArgumentException("Team name '" + name + "' is already in use");
        }
        TeamMock team = new TeamMock(name, this);
        this.teams.put(name, team);
        return team;
    }

    @Deprecated(since="1.7.10")
    @NotNull
    public Set<OfflinePlayer> getPlayers() {
        HashSet<OfflinePlayer> players = new HashSet<OfflinePlayer>();
        for (Team t : this.teams.values()) {
            players.addAll(t.getPlayers());
        }
        return players;
    }

    @NotNull
    public Set<String> getEntries() {
        HashSet<String> entries = new HashSet<String>();
        for (Team t : this.teams.values()) {
            entries.addAll(t.getEntries());
        }
        return entries;
    }

    public void clearSlot(@NotNull DisplaySlot slot) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)slot, (Object)"Slot cannot be null");
        this.objectivesByDisplaySlot.remove(slot);
    }

    @NotNull
    public Set<Score> getScoresFor(@NotNull Entity entity) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)entity, (Object)ENTITY_CANNOT_BE_NULL);
        return this.getScores(((EntityMock)entity).getScoreboardEntry());
    }

    public void resetScoresFor(@NotNull Entity entity) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)entity, (Object)ENTITY_CANNOT_BE_NULL);
        this.resetScores(((EntityMock)entity).getScoreboardEntry());
    }

    @Nullable
    public Team getEntityTeam(@NotNull Entity entity) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)entity, (Object)ENTITY_CANNOT_BE_NULL);
        return this.getEntryTeam(((EntityMock)entity).getScoreboardEntry());
    }

    protected void setDisplaySlot(@NotNull ObjectiveMock objective, DisplaySlot slot) {
        this.objectivesByDisplaySlot.put(slot, objective);
    }

    protected void unregister(@NotNull ObjectiveMock objectiveMock) {
        if (objectiveMock.getDisplaySlot() != null) {
            this.objectivesByDisplaySlot.remove(objectiveMock.getDisplaySlot());
        }
        this.objectives.remove(objectiveMock.getName());
    }

    protected void unregister(@NotNull TeamMock teamMock) {
        this.teams.remove(teamMock.getName());
    }
}

