/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.tags.internal;

import be.seeseemelk.mockbukkit.tags.internal.InternalTagMisconfigurationException;
import be.seeseemelk.mockbukkit.tags.internal.InternalTagParser;
import be.seeseemelk.mockbukkit.tags.internal.InternalTagRegistry;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;

public class InternalTag<T> {
    public static final InternalTag<Material> SOLID_BLOCKS = new InternalTag<Material>(InternalTagRegistry.BLOCKS, "SOLID_BLOCKS", Material.class);
    public static final InternalTag<Material> NON_SOLID_BLOCKS = new InternalTag<Material>(InternalTagRegistry.BLOCKS, "NON_SOLID_BLOCKS", Material.class);
    private final String name;
    private final Set<T> values;
    private final Class<T> relatedClass;

    private InternalTag(InternalTagRegistry registry, String name, Class<T> relatedClass) {
        registry.getRelatedTags().add(this);
        this.values = new HashSet<T>();
        this.name = name;
        this.relatedClass = relatedClass;
    }

    public Set<T> getValues() {
        return this.values;
    }

    public Class<T> getRelatedClass() {
        return this.relatedClass;
    }

    void addValues(Collection<T> value) {
        this.values.addAll(value);
    }

    public String getName() {
        return this.name;
    }

    public boolean isTagged(T value) {
        Preconditions.checkState((!this.values.isEmpty() ? 1 : 0) != 0, (Object)"Requires MockBukkit to be mocking");
        return this.values.contains(value);
    }

    public static void loadInternalTags() {
        for (InternalTagRegistry registry : InternalTagRegistry.values()) {
            InternalTagParser parser = new InternalTagParser();
            try {
                parser.insertInternalTagValues(registry);
            }
            catch (InternalTagMisconfigurationException | IOException e) {
                e.printStackTrace();
            }
        }
    }
}

