/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.ChunkSnapshotMock;
import be.seeseemelk.mockbukkit.Coordinate;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.persistence.PersistentDataContainerMock;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkMock
implements Chunk {
    private final World world;
    private final int x;
    private final int z;
    private final PersistentDataContainer persistentDataContainer = new PersistentDataContainerMock();
    private boolean isSlimeChunk;

    protected ChunkMock(World world, int x, int z) {
        this.world = world;
        this.x = x;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public boolean isGenerated() {
        return true;
    }

    @NotNull
    public BlockState[] getTileEntities(boolean useSnapshot) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Collection<BlockState> getTileEntities(@NotNull Predicate<? super Block> blockPredicate, boolean useSnapshot) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public World getWorld() {
        return this.world;
    }

    @NotNull
    public Block getBlock(int x, int y, int z) {
        Preconditions.checkArgument((0 <= x && x <= 15 ? 1 : 0) != 0, (String)"x out of range (expected 0-15, got %s)", (int)x);
        Preconditions.checkArgument((this.world.getMinHeight() <= y && y <= this.world.getMaxHeight() ? 1 : 0) != 0, (String)"y out of range (expected %s-%s, got %s)", (Object)this.world.getMinHeight(), (Object)this.world.getMaxHeight(), (Object)y);
        Preconditions.checkArgument((0 <= z && z <= 15 ? 1 : 0) != 0, (String)"z out of range (expected 0-15, got %s)", (int)z);
        return this.world.getBlockAt((this.x << 4) + x, y, (this.z << 4) + z);
    }

    @NotNull
    public Block getBlock(@NotNull Coordinate coordinate) {
        return this.getBlock(coordinate.x, coordinate.y, coordinate.z);
    }

    @NotNull
    public List<Block> getBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>(this.getCubicSize());
        for (int blockX = 0; blockX < 16; ++blockX) {
            for (int blockY = this.world.getMinHeight(); blockY < this.world.getMaxHeight(); ++blockY) {
                for (int blockZ = 0; blockZ < 16; ++blockZ) {
                    blocks.add(this.getBlock(blockX, blockY, blockZ));
                }
            }
        }
        return blocks;
    }

    @NotNull
    public ChunkSnapshot getChunkSnapshot() {
        return this.getChunkSnapshot(true, false, false);
    }

    @NotNull
    public ChunkSnapshot getChunkSnapshot(boolean includeMaxblocky, boolean includeBiome, boolean includeBiomeTempRain) {
        ImmutableMap.Builder blockData = ImmutableMap.builderWithExpectedSize((int)this.getCubicSize());
        ImmutableMap.Builder biomes = ImmutableMap.builderWithExpectedSize((int)this.getCubicSize());
        for (Block block : this.getBlocks()) {
            Coordinate chunkLocalCoordinate = new Coordinate(block.getX() % 16, block.getY(), block.getZ() % 16);
            blockData.put((Object)chunkLocalCoordinate, (Object)block.getBlockData());
            if (!includeBiome && !includeBiomeTempRain) continue;
            biomes.put((Object)chunkLocalCoordinate, (Object)block.getBiome());
        }
        return new ChunkSnapshotMock(this.x, this.z, this.world.getMinHeight(), this.world.getMaxHeight(), this.world.getName(), this.world.getFullTime(), (Map<Coordinate, BlockData>)blockData.build(), (Map<Coordinate, Biome>)(includeBiome || includeBiomeTempRain ? biomes.build() : null));
    }

    @NotNull
    public ChunkSnapshot getChunkSnapshot(boolean b, boolean b1, boolean b2, boolean b3) {
        throw new UnimplementedOperationException();
    }

    public boolean isEntitiesLoaded() {
        return this.isLoaded();
    }

    public Entity[] getEntities() {
        BoundingBox boundingBox = new BoundingBox((double)(this.x << 4), (double)this.world.getMinHeight(), (double)(this.z << 4), (double)((this.x << 4) + 16), (double)this.world.getMaxHeight(), (double)((this.z << 4) + 16));
        return this.world.getNearbyEntities(boundingBox).toArray(new Entity[0]);
    }

    public BlockState[] getTileEntities() {
        throw new UnimplementedOperationException();
    }

    public boolean isLoaded() {
        return this.world.isChunkLoaded((Chunk)this);
    }

    public boolean load(boolean generate) {
        return this.load();
    }

    public boolean load() {
        this.world.loadChunk((Chunk)this);
        return true;
    }

    public boolean unload(boolean save) {
        return this.world.unloadChunk(this.x, this.z, save);
    }

    public boolean unload() {
        return this.world.unloadChunk((Chunk)this);
    }

    public void setSlimeChunk(boolean isSlimeChunk) {
        this.isSlimeChunk = isSlimeChunk;
    }

    public boolean isSlimeChunk() {
        return this.isSlimeChunk;
    }

    public int hashCode() {
        return this.world.hashCode() + this.x + this.z;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ChunkMock) {
            ChunkMock chunk = (ChunkMock)obj;
            return this.x == chunk.x && this.z == chunk.z && this.world.equals(chunk.world);
        }
        return false;
    }

    public boolean isForceLoaded() {
        throw new UnimplementedOperationException();
    }

    public void setForceLoaded(boolean forced) {
        throw new UnimplementedOperationException();
    }

    public boolean addPluginChunkTicket(@NotNull Plugin plugin) {
        throw new UnimplementedOperationException();
    }

    public boolean removePluginChunkTicket(@NotNull Plugin plugin) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Collection<Plugin> getPluginChunkTickets() {
        throw new UnimplementedOperationException();
    }

    public long getInhabitedTime() {
        throw new UnimplementedOperationException();
    }

    public void setInhabitedTime(long ticks) {
        throw new UnimplementedOperationException();
    }

    public boolean contains(@NotNull BlockData block) {
        return this.getBlocks().stream().anyMatch(b -> b.getBlockData().equals(block));
    }

    public boolean contains(@NotNull Biome biome) {
        return this.getBlocks().stream().anyMatch(b -> b.getBiome() == biome);
    }

    @NotNull
    public Chunk.LoadLevel getLoadLevel() {
        return this.isLoaded() ? Chunk.LoadLevel.ENTITY_TICKING : Chunk.LoadLevel.UNLOADED;
    }

    @NotNull
    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    private int getCubicSize() {
        return 256 * Math.abs(this.world.getMaxHeight() - this.world.getMinHeight());
    }
}

