/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.data;

import be.seeseemelk.mockbukkit.block.data.BlockDataMock;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Bed;
import org.jetbrains.annotations.NotNull;

public class BedMock
extends BlockDataMock
implements Bed {
    public BedMock(@NotNull Material type) {
        super(type);
        this.checkType(type, (Tag<Material>)Tag.BEDS);
        this.setFacing(BlockFace.NORTH);
        super.set("occupied", false);
        this.setPart(Bed.Part.FOOT);
    }

    @NotNull
    public Bed.Part getPart() {
        return (Bed.Part)super.get("part");
    }

    public void setPart(@NotNull Bed.Part part) {
        super.set("part", part);
    }

    public boolean isOccupied() {
        return (Boolean)super.get("occupied");
    }

    public void setOccupied(boolean occupied) {
        super.set("occupied", occupied);
    }

    @NotNull
    public BlockFace getFacing() {
        return (BlockFace)super.get("facing");
    }

    public void setFacing(@NotNull BlockFace facing) {
        if (!this.getFaces().contains(facing)) {
            throw new IllegalArgumentException("Invalid face: " + facing);
        }
        super.set("facing", facing);
    }

    @NotNull
    public Set<BlockFace> getFaces() {
        return Set.of(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST);
    }
}

