/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.enchantments;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.papermc.paper.enchantments.EnchantmentRarity;
import java.util.HashSet;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.EntityCategory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EnchantmentMock
extends Enchantment {
    private static final String LEVEL = "level";
    private static final String COST = "cost";
    @NotNull
    private final String name;
    private final NamespacedKey key;
    private final boolean tradeable;
    private final boolean discoverable;
    private final EnchantmentRarity rarity;
    private final Set<NamespacedKey> conflicts;
    private boolean treasure;
    private final Component[] displayNames;
    private final int[] maxModifiedCosts;
    private boolean cursed;
    private final int[] minModifiedCosts;
    private int maxLevel;
    private int startLevel;
    private EnchantmentTarget itemTarget;

    public EnchantmentMock(JsonObject data) {
        this.key = NamespacedKey.fromString((String)data.get("key").getAsString());
        this.itemTarget = EnchantmentTarget.valueOf((String)data.get("itemTarget").getAsString());
        this.treasure = data.get("treasure").getAsBoolean();
        this.cursed = data.get("cursed").getAsBoolean();
        this.maxLevel = data.get("maxLevel").getAsInt();
        this.startLevel = data.get("startLevel").getAsInt();
        this.name = data.get("name").getAsString();
        this.displayNames = this.getDisplayNames(data.get("displayNames").getAsJsonArray(), this.maxLevel);
        this.minModifiedCosts = this.getMinModifiedCosts(data.get("minModifiedCosts").getAsJsonArray(), this.maxLevel);
        this.maxModifiedCosts = this.getMaxModifiedCosts(data.get("maxModifiedCosts").getAsJsonArray(), this.maxLevel);
        this.tradeable = data.get("tradeable").getAsBoolean();
        this.discoverable = data.get("discoverable").getAsBoolean();
        String rarityString = data.get("rarity").getAsString();
        this.rarity = EnchantmentRarity.valueOf((String)rarityString);
        this.conflicts = this.getConflicts(data.get("conflicts").getAsJsonArray());
    }

    private Set<NamespacedKey> getConflicts(JsonArray conflicts) {
        HashSet<NamespacedKey> output = new HashSet<NamespacedKey>();
        for (JsonElement conflict : conflicts) {
            output.add(NamespacedKey.fromString((String)conflict.getAsString()));
        }
        return output;
    }

    private Component[] getDisplayNames(JsonArray displayNamesData, int maxLevel) {
        Component[] output = new Component[maxLevel];
        for (JsonElement element : displayNamesData) {
            JsonObject displayNameData = element.getAsJsonObject();
            int level = displayNameData.get(LEVEL).getAsInt();
            GsonComponentSerializer gsonComponentSerializer = GsonComponentSerializer.builder().build();
            output[level - 1] = gsonComponentSerializer.deserializeFromTree(displayNameData.get("text"));
        }
        return output;
    }

    private int[] getMinModifiedCosts(JsonArray minModifiedCosts, int maxLevel) {
        int[] output = new int[maxLevel];
        for (JsonElement element : minModifiedCosts) {
            JsonObject minModifiedCost = element.getAsJsonObject();
            int level = minModifiedCost.get(LEVEL).getAsInt();
            output[level - 1] = minModifiedCost.get(COST).getAsInt();
        }
        return output;
    }

    private int[] getMaxModifiedCosts(JsonArray maxModifiedCosts, int maxLevel) {
        int[] output = new int[maxLevel];
        for (JsonElement element : maxModifiedCosts) {
            JsonObject maxModifiedCost = element.getAsJsonObject();
            int level = maxModifiedCost.get(LEVEL).getAsInt();
            output[level - 1] = maxModifiedCost.get(COST).getAsInt();
        }
        return output;
    }

    @NotNull
    public Component displayName(int level) {
        return this.displayNames[level - 1];
    }

    public boolean isTradeable() {
        return this.tradeable;
    }

    public boolean isDiscoverable() {
        return this.discoverable;
    }

    public int getMaxModifiedCost(int level) {
        return this.maxModifiedCosts[level - 1];
    }

    public int getMinModifiedCost(int level) {
        return this.minModifiedCosts[level - 1];
    }

    @NotNull
    public EnchantmentRarity getRarity() {
        return this.rarity;
    }

    public float getDamageIncrease(int level, @NotNull EntityCategory entityCategory) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Set<EquipmentSlot> getActiveSlots() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public String translationKey() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(int startLevel) {
        this.startLevel = startLevel;
    }

    @NotNull
    public EnchantmentTarget getItemTarget() {
        return this.itemTarget;
    }

    public void setItemTarget(@NotNull EnchantmentTarget itemTarget) {
        Preconditions.checkNotNull((Object)itemTarget, (Object)"EnchantmentTarget cannot be null");
        this.itemTarget = itemTarget;
    }

    public boolean isTreasure() {
        return this.treasure;
    }

    public void setTreasure(boolean isTreasure) {
        this.treasure = isTreasure;
    }

    public boolean isCursed() {
        return this.cursed;
    }

    public void setCursed(boolean isCursed) {
        this.cursed = isCursed;
    }

    public boolean conflictsWith(@NotNull Enchantment other) {
        Preconditions.checkArgument((other != null ? 1 : 0) != 0, (Object)"others can't be null");
        return this.conflicts.contains(other.getKey());
    }

    public boolean canEnchantItem(@NotNull ItemStack item) {
        Preconditions.checkNotNull((Object)item, (Object)"Item cannot be null");
        return false;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }
}

