/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.AsyncCatcher;
import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.WorldMock;
import be.seeseemelk.mockbukkit.command.MessageTarget;
import be.seeseemelk.mockbukkit.entity.data.EntityData;
import be.seeseemelk.mockbukkit.entity.data.EntityDataRegistry;
import be.seeseemelk.mockbukkit.entity.data.EntityState;
import be.seeseemelk.mockbukkit.entity.data.EntitySubType;
import be.seeseemelk.mockbukkit.metadata.MetadataTable;
import be.seeseemelk.mockbukkit.persistence.PersistentDataContainerMock;
import com.google.common.base.Preconditions;
import io.papermc.paper.entity.TeleportFlag;
import io.papermc.paper.threadedregions.scheduler.EntityScheduler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.spigotmc.event.entity.EntityDismountEvent;
import org.spigotmc.event.entity.EntityMountEvent;

public abstract class EntityMock
extends Entity.Spigot
implements Entity,
MessageTarget {
    private static final AtomicInteger ENTITY_COUNTER = new AtomicInteger();
    @NotNull
    protected final ServerMock server;
    @NotNull
    private final UUID uuid;
    private final int id;
    private Location location;
    private boolean teleported;
    private PlayerTeleportEvent.TeleportCause teleportCause;
    @Nullable
    private EntityMock vehicle;
    private final List<Entity> passengers = new ArrayList<Entity>(0);
    private final MetadataTable metadataTable = new MetadataTable();
    private final PersistentDataContainer persistentDataContainer = new PersistentDataContainerMock();
    @NotNull
    private Component name = Component.text((String)"entity");
    @Nullable
    private Component customName = null;
    private boolean customNameVisible = false;
    private boolean invulnerable;
    private boolean persistent = true;
    private boolean glowingFlag = false;
    private final Queue<Component> messages = new LinkedTransferQueue<Component>();
    private final PermissibleBase perms;
    @NotNull
    private Vector velocity = new Vector(0, 0, 0);
    private float fallDistance;
    private int fireTicks = -20;
    private final int maxFireTicks = 20;
    private boolean removed = false;
    @Nullable
    private EntityDamageEvent lastDamageEvent;
    private boolean visualFire;
    private boolean silent;
    private boolean gravity = true;
    private final EntityData entityData;
    private CreatureSpawnEvent.SpawnReason spawnReason = CreatureSpawnEvent.SpawnReason.CUSTOM;

    protected EntityMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        Preconditions.checkNotNull((Object)((Object)server), (Object)"Server cannot be null");
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID cannot be null");
        this.server = server;
        this.uuid = uuid;
        this.id = ENTITY_COUNTER.incrementAndGet();
        this.perms = new PermissibleBase((ServerOperator)this);
        this.location = !Bukkit.getWorlds().isEmpty() ? ((World)Bukkit.getWorlds().get(0)).getSpawnLocation() : new Location(null, 0.0, 0.0, 0.0);
        this.entityData = EntityDataRegistry.loadEntityData(this.getType());
    }

    public final int hashCode() {
        return this.uuid.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof EntityMock) {
            return this.uuid.equals(((EntityMock)obj).getUniqueId());
        }
        return false;
    }

    public void assertLocation(@NotNull Location expectedLocation, double maximumDistance) {
        double distance = this.location.distance(expectedLocation);
        Assertions.assertEquals((Object)expectedLocation.getWorld(), (Object)this.location.getWorld());
        Assertions.assertTrue((distance <= maximumDistance ? 1 : 0) != 0, (String)String.format("Distance was <%.3f> but should be less than or equal to <%.3f>", distance, maximumDistance));
    }

    public void assertTeleported(@NotNull Location expectedLocation, double maximumDistance) {
        Assertions.assertTrue((boolean)this.teleported, (String)"Player did not teleport");
        this.assertLocation(expectedLocation, maximumDistance);
        this.teleported = false;
    }

    public void assertNotTeleported() {
        Assertions.assertFalse((boolean)this.teleported, (String)"Player was teleported");
        this.teleported = false;
    }

    public boolean hasTeleported() {
        return this.teleported;
    }

    public void clearTeleported() {
        this.teleported = false;
    }

    public PlayerTeleportEvent.TeleportCause getTeleportCause() {
        return this.teleportCause;
    }

    @NotNull
    public UUID getUniqueId() {
        return this.uuid;
    }

    @NotNull
    public Location getLocation() {
        return this.location.clone();
    }

    @NotNull
    public Set<Player> getTrackedPlayers() {
        throw new UnimplementedOperationException();
    }

    public Location getLocation(@Nullable Location loc) {
        if (loc == null) {
            return null;
        }
        loc.setWorld(this.location.getWorld());
        loc.setDirection(this.location.getDirection());
        loc.setX(this.location.getX());
        loc.setY(this.location.getY());
        loc.setZ(this.location.getZ());
        return loc;
    }

    public void setLocation(@NotNull Location location) {
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
        Location position = location.clone();
        if (position.getWorld() == null) {
            position.setWorld((World)this.getWorld());
        }
        this.location = position;
    }

    @NotNull
    public WorldMock getWorld() {
        return (WorldMock)this.location.getWorld();
    }

    public void setMetadata(@NotNull String metadataKey, @NotNull MetadataValue newMetadataValue) {
        Preconditions.checkNotNull((Object)metadataKey, (Object)"Metadata key cannot be null");
        this.metadataTable.setMetadata(metadataKey, newMetadataValue);
    }

    @NotNull
    public List<MetadataValue> getMetadata(@NotNull String metadataKey) {
        Preconditions.checkNotNull((Object)metadataKey, (Object)"Metadata key cannot be null");
        return this.metadataTable.getMetadata(metadataKey);
    }

    public boolean hasMetadata(@NotNull String metadataKey) {
        Preconditions.checkNotNull((Object)metadataKey, (Object)"Metadata key cannot be null");
        return this.metadataTable.hasMetadata(metadataKey);
    }

    public void removeMetadata(@NotNull String metadataKey, @NotNull Plugin owningPlugin) {
        Preconditions.checkNotNull((Object)metadataKey, (Object)"Metadata key cannot be null");
        this.metadataTable.removeMetadata(metadataKey, owningPlugin);
    }

    public void clearMetadata(Plugin plugin) {
        this.metadataTable.clearMetadata(plugin);
    }

    @NotNull
    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    public boolean teleport(@NotNull Location location) {
        return this.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public boolean teleport(@NotNull Location location, @NotNull PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(location, cause, new TeleportFlag[0]);
    }

    public boolean teleport(@NotNull Location location, @NotNull PlayerTeleportEvent.TeleportCause cause, TeleportFlag ... flags) {
        EntityTeleportEvent event;
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
        location.checkFinite();
        Set<TeleportFlag> flagSet = Set.of(flags);
        boolean dismount = !flagSet.contains(TeleportFlag.EntityState.RETAIN_VEHICLE);
        boolean ignorePassengers = flagSet.contains(TeleportFlag.EntityState.RETAIN_PASSENGERS);
        if (flagSet.contains(TeleportFlag.EntityState.RETAIN_PASSENGERS) && this.hasPassengers() && location.getWorld().equals(this.getWorld())) {
            return false;
        }
        if (!dismount && this.getVehicle() != null && location.getWorld() != this.getWorld()) {
            return false;
        }
        if (this.removed || !ignorePassengers && this.hasPassengers()) {
            return false;
        }
        if (location.getWorld() != this.getWorld() && (ignorePassengers && this.hasPassengers() || !dismount && this.isInsideVehicle())) {
            return false;
        }
        if (dismount) {
            this.leaveVehicle();
        }
        if ((event = new EntityTeleportEvent((Entity)this, this.getLocation(), location)).callEvent()) {
            Preconditions.checkNotNull((Object)event.getTo(), (Object)"The location where the entity moved to in the event cannot be null");
            this.teleportWithoutEvent(event.getTo(), cause);
            return true;
        }
        return false;
    }

    protected void teleportWithoutEvent(@NotNull Location location, @NotNull PlayerTeleportEvent.TeleportCause cause) {
        this.setLocation(location);
        this.teleported = true;
        this.teleportCause = cause;
    }

    public boolean teleport(@NotNull Entity destination) {
        Preconditions.checkNotNull((Object)destination, (Object)"Destination entity cannot be null");
        return this.teleport(destination, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public boolean teleport(@NotNull Entity destination, @NotNull PlayerTeleportEvent.TeleportCause cause) {
        Preconditions.checkNotNull((Object)destination, (Object)"Destination entity cannot be null");
        Preconditions.checkNotNull((Object)cause, (Object)"TeleportCause cannot be null");
        return this.teleport(destination.getLocation(), cause);
    }

    public boolean isOp() {
        return false;
    }

    public void setOp(boolean isOperator) {
        throw new UnsupportedOperationException("This does nothing in CraftBukkit");
    }

    @NotNull
    public String getName() {
        return LegacyComponentSerializer.legacySection().serialize(this.name);
    }

    @NotNull
    public String getScoreboardEntry() {
        return this.uuid.toString();
    }

    public void setName(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        this.name = LegacyComponentSerializer.legacySection().deserialize(name);
    }

    public void sendMessage(@NotNull String message) {
        this.sendMessage((UUID)null, message);
    }

    public void sendMessage(String ... messages) {
        this.sendMessage((UUID)null, messages);
    }

    public void sendMessage(@Nullable UUID sender, @NotNull String message) {
        Preconditions.checkNotNull((Object)message, (Object)"Message cannot be null");
        this.sendMessage(sender == null ? Identity.nil() : Identity.identity((UUID)sender), (Component)LegacyComponentSerializer.legacySection().deserialize(message), MessageType.SYSTEM);
    }

    public void sendMessage(UUID sender, String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    public void sendMessage(@NotNull Identity source, @NotNull Component message, @NotNull MessageType type) {
        Preconditions.checkNotNull((Object)source, (Object)"Source cannot be null");
        Preconditions.checkNotNull((Object)message, (Object)"Message cannot be null");
        Preconditions.checkNotNull((Object)type, (Object)"MessageType cannot be null");
        this.messages.add(message);
    }

    @Override
    @Nullable
    public Component nextComponentMessage() {
        return this.messages.poll();
    }

    public boolean isPermissionSet(@NotNull String name) {
        return this.perms.isPermissionSet(name);
    }

    public boolean isPermissionSet(@NotNull Permission perm) {
        return this.perms.isPermissionSet(perm);
    }

    public boolean hasPermission(@NotNull String name) {
        return this.perms.hasPermission(name);
    }

    public boolean hasPermission(@NotNull Permission perm) {
        return this.perms.hasPermission(perm);
    }

    @NotNull
    public PermissionAttachment addAttachment(@NotNull Plugin plugin, @NotNull String name, boolean value) {
        return this.perms.addAttachment(plugin, name, value);
    }

    @NotNull
    public PermissionAttachment addAttachment(@NotNull Plugin plugin) {
        return this.perms.addAttachment(plugin);
    }

    public PermissionAttachment addAttachment(@NotNull Plugin plugin, @NotNull String name, boolean value, int ticks) {
        return this.perms.addAttachment(plugin, name, value, ticks);
    }

    public PermissionAttachment addAttachment(@NotNull Plugin plugin, int ticks) {
        return this.perms.addAttachment(plugin, ticks);
    }

    public void removeAttachment(@NotNull PermissionAttachment attachment) {
        this.perms.removeAttachment(attachment);
    }

    public void recalculatePermissions() {
        this.perms.recalculatePermissions();
    }

    @NotNull
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return this.perms.getEffectivePermissions();
    }

    @Nullable
    public Component customName() {
        return this.customName;
    }

    public void customName(@Nullable Component customName) {
        this.customName = customName;
    }

    public String getCustomName() {
        return this.customName == null ? null : LegacyComponentSerializer.legacySection().serialize(this.customName);
    }

    public void setCustomName(@Nullable String name) {
        this.customName = name == null ? null : LegacyComponentSerializer.legacySection().deserialize(name);
    }

    public void setVelocity(@NotNull Vector velocity) {
        Preconditions.checkNotNull((Object)velocity, (Object)"Velocity cannot be null");
        this.velocity = velocity;
    }

    @NotNull
    public Vector getVelocity() {
        return this.velocity;
    }

    public double getHeight() {
        return this.entityData.getHeight(this.getSubType(), this.getEntityState());
    }

    public double getWidth() {
        return this.entityData.getWidth(this.getSubType(), this.getEntityState());
    }

    protected EntityState getEntityState() {
        return EntityState.DEFAULT;
    }

    protected EntitySubType getSubType() {
        return EntitySubType.DEFAULT;
    }

    public boolean isOnGround() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public List<Entity> getNearbyEntities(double x, double y, double z) {
        AsyncCatcher.catchOp("getNearbyEntities");
        ArrayList<Entity> nearbyEntities = new ArrayList<Entity>();
        this.getWorld().getEntities().forEach(entity -> {
            Vector distance = entity.getLocation().clone().subtract(this.getLocation()).toVector();
            if (Math.abs(distance.getX()) <= x && Math.abs(distance.getY()) <= y && Math.abs(distance.getZ()) <= z && entity != this) {
                nearbyEntities.add((Entity)entity);
            }
        });
        return nearbyEntities;
    }

    public int getEntityId() {
        return this.id;
    }

    public int getFireTicks() {
        return this.fireTicks;
    }

    public int getMaxFireTicks() {
        return 20;
    }

    public void setFireTicks(int ticks) {
        this.fireTicks = ticks;
    }

    public void setVisualFire(boolean fire) {
        this.visualFire = fire;
    }

    public boolean isVisualFire() {
        return this.visualFire;
    }

    public void setFreezeTicks(int ticks) {
        throw new UnimplementedOperationException();
    }

    public boolean isFrozen() {
        throw new UnimplementedOperationException();
    }

    public boolean isFreezeTickingLocked() {
        throw new UnimplementedOperationException();
    }

    public void lockFreezeTicks(boolean locked) {
        throw new UnimplementedOperationException();
    }

    public int getFreezeTicks() {
        throw new UnimplementedOperationException();
    }

    public int getMaxFreezeTicks() {
        throw new UnimplementedOperationException();
    }

    public void remove() {
        this.leaveVehicle();
        if (this.hasPassengers()) {
            new ArrayList<Entity>(this.passengers).forEach(Entity::leaveVehicle);
        }
        this.removed = true;
        this.server.unregisterEntity(this);
    }

    public boolean isDead() {
        return this.removed;
    }

    public boolean isValid() {
        return !this.removed;
    }

    @NotNull
    public ServerMock getServer() {
        return this.server;
    }

    @Deprecated(since="1.12")
    public Entity getPassenger() {
        return this.isEmpty() ? null : this.passengers.get(0);
    }

    @Deprecated(since="1.12")
    public boolean setPassenger(@NotNull Entity passenger) {
        this.eject();
        return this.addPassenger(passenger);
    }

    @NotNull
    public List<Entity> getPassengers() {
        return Collections.unmodifiableList(this.passengers);
    }

    @NotNull
    public Set<Player> getTrackedBy() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public List<Entity> getTransitivePassengers() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Entity passenger : this.passengers) {
            entities.add(passenger);
            entities.addAll(((EntityMock)passenger).getTransitivePassengers());
        }
        return List.copyOf(entities);
    }

    public boolean addPassenger(@NotNull Entity passenger) {
        Preconditions.checkNotNull((Object)passenger, (Object)"Passenger cannot be null.");
        Preconditions.checkArgument((!this.equals(passenger) ? 1 : 0) != 0, (Object)"Entity cannot ride itself.");
        if (passenger.getVehicle() == this) {
            return false;
        }
        for (Entity current = this.getVehicle(); current != null; current = current.getVehicle()) {
            if (current != passenger) continue;
            return false;
        }
        ((EntityMock)passenger).vehicle = this;
        if (!this.tryAddingPassenger(passenger)) {
            ((EntityMock)passenger).vehicle = null;
            return false;
        }
        return true;
    }

    public boolean removePassenger(@NotNull Entity passenger) {
        Preconditions.checkNotNull((Object)passenger, (Object)"Passenger cannot be null.");
        passenger.leaveVehicle();
        return true;
    }

    public boolean isEmpty() {
        return this.passengers.isEmpty();
    }

    public boolean hasPassengers() {
        return !this.isEmpty();
    }

    public boolean eject() {
        if (this.isEmpty()) {
            return false;
        }
        this.passengers.clear();
        return true;
    }

    public float getFallDistance() {
        return this.fallDistance;
    }

    public void setFallDistance(float distance) {
        this.fallDistance = distance;
    }

    public void setLastDamageCause(@Nullable EntityDamageEvent event) {
        this.lastDamageEvent = event;
    }

    @Nullable
    public EntityDamageEvent getLastDamageCause() {
        return this.lastDamageEvent;
    }

    public int getTicksLived() {
        throw new UnimplementedOperationException();
    }

    public void setTicksLived(int value) {
        throw new UnimplementedOperationException();
    }

    public void playEffect(@NotNull EntityEffect type) {
        Preconditions.checkNotNull((Object)type, (Object)"Type cannot be null");
    }

    @NotNull
    public EntityType getType() {
        return EntityType.UNKNOWN;
    }

    @NotNull
    public Sound getSwimSound() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Sound getSwimSplashSound() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Sound getSwimHighSpeedSplashSound() {
        throw new UnimplementedOperationException();
    }

    public boolean isInsideVehicle() {
        return this.vehicle != null;
    }

    public boolean leaveVehicle() {
        if (this.vehicle == null) {
            return false;
        }
        EntityMock previousVehicle = this.vehicle;
        this.vehicle = null;
        if (!previousVehicle.tryRemovingPassenger(this)) {
            this.vehicle = previousVehicle;
        }
        return true;
    }

    @Nullable
    public Entity getVehicle() {
        return this.vehicle;
    }

    private boolean tryAddingPassenger(@NotNull Entity entity) {
        if (this.getWorld() != entity.getWorld()) {
            return false;
        }
        EntityMock entityMock = this;
        if (entityMock instanceof Vehicle) {
            Vehicle selfVehicle = (Vehicle)entityMock;
            if (entity instanceof LivingEntity && (!new VehicleEnterEvent(selfVehicle, entity).callEvent() || entity.getVehicle() != this)) {
                return false;
            }
        }
        if (!new EntityMountEvent(entity, (Entity)this).callEvent()) {
            return false;
        }
        return this.passengers.add(entity);
    }

    private boolean tryRemovingPassenger(@NotNull Entity entity) {
        EntityMock entityMock = this;
        if (entityMock instanceof Vehicle) {
            LivingEntity livingEntity;
            Vehicle selfVehicle = (Vehicle)entityMock;
            if (entity instanceof LivingEntity && (!new VehicleExitEvent(selfVehicle, livingEntity = (LivingEntity)entity).callEvent() || entity.getVehicle() != this)) {
                return false;
            }
        }
        if (!new EntityDismountEvent(entity, (Entity)this).callEvent()) {
            return false;
        }
        return this.passengers.remove(entity);
    }

    public void setCustomNameVisible(boolean flag) {
        this.customNameVisible = flag;
    }

    public boolean isCustomNameVisible() {
        return this.customNameVisible;
    }

    public void setGlowing(boolean flag) {
        this.glowingFlag = flag;
    }

    public boolean isGlowing() {
        return this.glowingFlag;
    }

    public void setInvulnerable(boolean flag) {
        this.invulnerable = flag;
    }

    public boolean isInvulnerable() {
        return this.invulnerable;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean hasGravity() {
        return this.gravity;
    }

    public void setGravity(boolean gravity) {
        this.gravity = gravity;
    }

    public int getPortalCooldown() {
        throw new UnimplementedOperationException();
    }

    public void setPortalCooldown(int cooldown) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Set<String> getScoreboardTags() {
        throw new UnimplementedOperationException();
    }

    public boolean addScoreboardTag(@NotNull String tag) {
        throw new UnimplementedOperationException();
    }

    public boolean removeScoreboardTag(@NotNull String tag) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public PistonMoveReaction getPistonMoveReaction() {
        throw new UnimplementedOperationException();
    }

    public void setRotation(float yaw, float pitch) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BoundingBox getBoundingBox() {
        throw new UnimplementedOperationException();
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    @NotNull
    public BlockFace getFacing() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Pose getPose() {
        throw new UnimplementedOperationException();
    }

    public boolean isInWater() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public SpawnCategory getSpawnCategory() {
        return SpawnCategory.MISC;
    }

    @NotNull
    public Entity copy(@NotNull Location to) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Entity copy() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public EntitySnapshot createSnapshot() {
        throw new UnimplementedOperationException();
    }

    public boolean isInWorld() {
        throw new UnimplementedOperationException();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.Spigot spigot() {
        return this;
    }

    @NotNull
    public Component name() {
        return this.name;
    }

    @NotNull
    public Component teamDisplayName() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public HoverEvent<HoverEvent.ShowEntity> asHoverEvent() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Location getOrigin() {
        throw new UnimplementedOperationException();
    }

    public boolean fromMobSpawner() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Chunk getChunk() {
        return this.getLocation().getChunk();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull CreatureSpawnEvent.SpawnReason getEntitySpawnReason() {
        return this.spawnReason;
    }

    public boolean isUnderWater() {
        throw new UnimplementedOperationException();
    }

    public boolean isInRain() {
        throw new UnimplementedOperationException();
    }

    public boolean isInBubbleColumn() {
        throw new UnimplementedOperationException();
    }

    public boolean isInWaterOrRain() {
        throw new UnimplementedOperationException();
    }

    public boolean isInWaterOrBubbleColumn() {
        throw new UnimplementedOperationException();
    }

    public boolean isInWaterOrRainOrBubbleColumn() {
        throw new UnimplementedOperationException();
    }

    public boolean isInLava() {
        throw new UnimplementedOperationException();
    }

    public boolean isTicking() {
        throw new UnimplementedOperationException();
    }

    public boolean spawnAt(@NotNull Location location) {
        throw new UnimplementedOperationException();
    }

    public boolean spawnAt(@NotNull Location location, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull CreatureSpawnEvent.SpawnReason reason) {
        throw new UnimplementedOperationException();
    }

    public boolean isInPowderedSnow() {
        throw new UnimplementedOperationException();
    }

    public boolean collidesAt(@NotNull Location location) {
        throw new UnimplementedOperationException();
    }

    public boolean wouldCollideUsing(@NotNull BoundingBox boundingBox) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public EntityScheduler getScheduler() {
        throw new UnimplementedOperationException();
    }

    public boolean isSneaking() {
        throw new UnimplementedOperationException();
    }

    public void setSneaking(boolean sneak) {
        throw new UnimplementedOperationException();
    }

    public void setVisibleByDefault(boolean visible) {
        throw new UnimplementedOperationException();
    }

    public boolean isVisibleByDefault() {
        throw new UnimplementedOperationException();
    }

    public void setPose(@NotNull Pose pose, boolean fixed) {
        throw new UnsupportedOperationException();
    }

    public boolean hasFixedPose() {
        throw new UnsupportedOperationException();
    }

    public double getX() {
        return this.getLocation().getX();
    }

    public double getY() {
        return this.getLocation().getY();
    }

    public double getZ() {
        return this.getLocation().getZ();
    }

    public float getPitch() {
        return this.getLocation().getPitch();
    }

    public float getYaw() {
        return this.getLocation().getYaw();
    }

    @NotNull
    public String getScoreboardEntryName() {
        throw new UnsupportedOperationException();
    }

    @ApiStatus.Internal
    public void setSpawnReason(CreatureSpawnEvent.SpawnReason spawnReason) {
        this.spawnReason = spawnReason;
    }
}

