/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.ban.MockProfileBanList;
import be.seeseemelk.mockbukkit.entity.PlayerMock;
import be.seeseemelk.mockbukkit.profile.PlayerProfileMock;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.ban.ProfileBanList;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OfflinePlayerMock
implements OfflinePlayer {
    @NotNull
    private final UUID uuid;
    @Nullable
    private final String name;

    public OfflinePlayerMock(@NotNull UUID uuid, @Nullable String name) {
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID cannot be null");
        this.uuid = uuid;
        this.name = name;
    }

    public OfflinePlayerMock(@Nullable String name) {
        this(UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes()), name);
    }

    @NotNull
    public PlayerMock join(@NotNull ServerMock server) {
        Preconditions.checkNotNull((Object)((Object)server), (Object)"Server cannot be null");
        Preconditions.checkState((!this.isOnline() ? 1 : 0) != 0, (Object)"Player already online");
        PlayerMock player = new PlayerMock(server, this.name, this.uuid);
        server.addPlayer(player);
        return player;
    }

    public boolean isOnline() {
        return this.getPlayer() != null;
    }

    public boolean isConnected() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @NotNull
    public UUID getUniqueId() {
        return this.uuid;
    }

    public boolean isOp() {
        return MockBukkit.getMock().getPlayerList().getOperators().contains(this);
    }

    public void setOp(boolean value) {
        if (value) {
            MockBukkit.getMock().getPlayerList().addOperator(this.uuid);
        } else {
            MockBukkit.getMock().getPlayerList().removeOperator(this.uuid);
        }
    }

    @NotNull
    public Map<String, Object> serialize() {
        return Map.of("UUID", this.uuid.toString());
    }

    public boolean isBanned() {
        MockBukkit.ensureMocking();
        return ((MockProfileBanList)Bukkit.getBanList((BanList.Type)BanList.Type.PROFILE)).isBanned(this.getPlayerProfile());
    }

    @Nullable
    public BanEntry<PlayerProfile> ban(@Nullable String reason, @Nullable Date expires, @Nullable String source) {
        MockBukkit.ensureMocking();
        return ((ProfileBanList)Bukkit.getBanList((BanList.Type)BanList.Type.PROFILE)).addBan(this.getPlayerProfile(), reason, expires, source);
    }

    @Nullable
    public BanEntry<PlayerProfile> ban(@Nullable String reason, @Nullable Instant expires, @Nullable String source) {
        MockBukkit.ensureMocking();
        return ((ProfileBanList)Bukkit.getBanList((BanList.Type)BanList.Type.PROFILE)).addBan((Object)this.getPlayerProfile(), reason, expires, source);
    }

    @Nullable
    public BanEntry<PlayerProfile> ban(@Nullable String reason, @Nullable Duration duration, @Nullable String source) {
        MockBukkit.ensureMocking();
        return ((ProfileBanList)Bukkit.getBanList((BanList.Type)BanList.Type.PROFILE)).addBan((Object)this.getPlayerProfile(), reason, duration, source);
    }

    public boolean isWhitelisted() {
        MockBukkit.ensureMocking();
        return Bukkit.getWhitelistedPlayers().contains(this);
    }

    public void setWhitelisted(boolean value) {
        MockBukkit.ensureMocking();
        Bukkit.getWhitelistedPlayers().add(this);
    }

    @Nullable
    public Player getPlayer() {
        MockBukkit.ensureMocking();
        return Bukkit.getPlayer((UUID)this.getUniqueId());
    }

    public long getFirstPlayed() {
        MockBukkit.ensureMocking();
        return MockBukkit.getMock().getPlayerList().getFirstPlayed(this.getUniqueId());
    }

    @Deprecated(since="1.13")
    public long getLastPlayed() {
        return this.getLastSeen();
    }

    public boolean hasPlayedBefore() {
        MockBukkit.ensureMocking();
        return MockBukkit.getMock().getPlayerList().hasPlayedBefore(this.getUniqueId());
    }

    @Nullable
    public Location getBedSpawnLocation() {
        throw new UnimplementedOperationException();
    }

    public long getLastLogin() {
        MockBukkit.ensureMocking();
        return MockBukkit.getMock().getPlayerList().getLastLogin(this.getUniqueId());
    }

    public long getLastSeen() {
        MockBukkit.ensureMocking();
        return MockBukkit.getMock().getPlayerList().getLastSeen(this.getUniqueId());
    }

    @Nullable
    public Location getRespawnLocation() {
        throw new UnimplementedOperationException();
    }

    public void incrementStatistic(@NotNull Statistic statistic) {
        throw new UnimplementedOperationException();
    }

    public void decrementStatistic(@NotNull Statistic statistic) {
        throw new UnimplementedOperationException();
    }

    public void incrementStatistic(@NotNull Statistic statistic, int amount) {
        throw new UnimplementedOperationException();
    }

    public void decrementStatistic(@NotNull Statistic statistic, int amount) {
        throw new UnimplementedOperationException();
    }

    public void setStatistic(@NotNull Statistic statistic, int newValue) {
        throw new UnimplementedOperationException();
    }

    public int getStatistic(@NotNull Statistic statistic) {
        throw new UnimplementedOperationException();
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull Material material) {
        throw new UnimplementedOperationException();
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull Material material) {
        throw new UnimplementedOperationException();
    }

    public int getStatistic(@NotNull Statistic statistic, @NotNull Material material) {
        throw new UnimplementedOperationException();
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull Material material, int amount) {
        throw new UnimplementedOperationException();
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull Material material, int amount) {
        throw new UnimplementedOperationException();
    }

    public void setStatistic(@NotNull Statistic statistic, @NotNull Material material, int newValue) {
        throw new UnimplementedOperationException();
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType) {
        throw new UnimplementedOperationException();
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType) {
        throw new UnimplementedOperationException();
    }

    public int getStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType) {
        throw new UnimplementedOperationException();
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType, int amount) {
        throw new UnimplementedOperationException();
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType, int amount) {
        throw new UnimplementedOperationException();
    }

    public void setStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType, int newValue) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Location getLastDeathLocation() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Location getLocation() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public PlayerProfile getPlayerProfile() {
        return new PlayerProfileMock(this);
    }
}

