/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.MobMock;
import java.util.UUID;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Slime;
import org.jetbrains.annotations.NotNull;

public class SlimeMock
extends MobMock
implements Slime {
    private int size = 1;
    private boolean canWander = true;

    public SlimeMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Size cannot be less than 1");
        }
        if (size > 127) {
            throw new IllegalArgumentException("Size cannot be greater than 127");
        }
        if (this.getHealth() > 0.0) {
            this.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue((double)(size * size));
            this.setHealth(this.getMaxHealth());
        }
        this.size = size;
    }

    public boolean canWander() {
        return this.canWander;
    }

    public void setWander(boolean canWander) {
        this.canWander = canWander;
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.SLIME;
    }
}

